/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.aaron;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u00020\f*\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0011\u001a\u00020\f*\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0010J\u0011\u0010\u0013\u001a\u00020\u0005*\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0014J\u0011\u0010\u0015\u001a\u00020\u0005*\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0014J\n\u0010\u0016\u001a\u00020\u0005*\u00020\u0017J\n\u0010\u0018\u001a\u00020\u0010*\u00020\u0019J\n\u0010\u001a\u001a\u00020\u0010*\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\u0005*\u00020\u00172\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0012\u0010\u001c\u001a\u00020\u0005*\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001fJ\u0018\u0010\u001c\u001a\u00020\u0005*\u00020\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!J\u001e\u0010\"\u001a\u00020\u0005\"\u0004\b\u0000\u0010#*\b\u0012\u0004\u0012\u0002H#0\u001e2\u0006\u0010$\u001a\u00020%J$\u0010\"\u001a\u00020\u0005\"\u0004\b\u0000\u0010#*\b\u0012\u0004\u0012\u0002H#0\u001e2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H#0'J$\u0010\"\u001a\u00020\u0005\"\u0004\b\u0000\u0010#*\b\u0012\u0004\u0012\u0002H#0\u001e2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H#0!J\u0012\u0010)\u001a\u00020\u0005*\u00020*2\u0006\u0010+\u001a\u00020,J\u0018\u0010)\u001a\u00020\u0005*\u00020*2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0\u001eJ\u0018\u0010)\u001a\u00020\u0005*\u00020*2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020,0'J\u0018\u0010)\u001a\u00020\u0005*\u00020*2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020,0!J\u0018\u0010.\u001a\u00020\u0005*\u00020/2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002000!J\u0018\u0010.\u001a\u00020\u0005*\u00020/2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002000'J \u00101\u001a\u00020\u0005*\u0006\u0012\u0002\b\u0003022\u0010\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003020!J\u001c\u00101\u001a\u00020\u0005*\u00020\t2\u0010\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003020!J\n\u00103\u001a\u000204*\u000205J\u0010\u00103\u001a\u000204*\b\u0012\u0004\u0012\u00020\u001f0!J\u001a\u00106\u001a\u000207*\u0002082\u0006\u00109\u001a\u0002072\u0006\u0010:\u001a\u000207J\u001a\u00106\u001a\u00020;*\u0002082\u0006\u00109\u001a\u00020;2\u0006\u0010:\u001a\u00020;J\u001a\u00106\u001a\u00020<*\u0002082\u0006\u00109\u001a\u00020<2\u0006\u0010:\u001a\u00020<J\u0012\u0010=\u001a\u00020\u0005*\u0002082\u0006\u0010=\u001a\u00020>J\n\u0010?\u001a\u00020;*\u00020>J\n\u0010@\u001a\u00020;*\u00020>J+\u0010A\u001a\u00020\u0017\"\u0004\b\u0000\u0010#*\u0002052\f\u0010B\u001a\b\u0012\u0004\u0012\u0002H#0C2\u0006\u0010D\u001a\u0002H#\u00a2\u0006\u0002\u0010EJ+\u0010A\u001a\u00020\u0017\"\u0004\b\u0000\u0010#*\u00020\u00172\f\u0010B\u001a\b\u0012\u0004\u0012\u0002H#0C2\u0006\u0010D\u001a\u0002H#\u00a2\u0006\u0002\u0010FJ\u0014\u0010G\u001a\u0004\u0018\u00010H*\u00020I2\u0006\u0010J\u001a\u00020\u0010J\n\u0010K\u001a\u00020L*\u00020MJ\u0017\u0010N\u001a\u0002H#\"\u0004\b\u0000\u0010#*\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010OJ\u0012\u0010P\u001a\u00020Q*\u00020Q2\u0006\u0010D\u001a\u00020\u000fJ\u0012\u0010P\u001a\u00020Q*\u00020Q2\u0006\u0010R\u001a\u00020\u0010J\u0012\u0010S\u001a\u00020Q*\u00020Q2\u0006\u0010T\u001a\u00020\u0010J\u0012\u0010U\u001a\u00020Q*\u00020Q2\u0006\u0010T\u001a\u00020\u0010J\u0012\u0010V\u001a\u00020Q*\u00020Q2\u0006\u0010W\u001a\u00020\u0010J\u0012\u0010X\u001a\u00020Q*\u00020Q2\u0006\u0010R\u001a\u00020\u0010J\u000e\u0010Y\u001a\u00020Z*\u0006\u0012\u0002\b\u00030[R\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007R\u0015\u0010\b\u001a\u00020\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\\"}, d2={"Ldev/aaronhowser/mods/aaron/AaronExtensions;", "", "<init>", "()V", "isServerSide", "", "Lnet/minecraft/world/level/Level;", "(Lnet/minecraft/world/level/Level;)Z", "isClientSide", "Lnet/minecraft/world/entity/Entity;", "(Lnet/minecraft/world/entity/Entity;)Z", "status", "", "Lnet/minecraft/world/entity/player/Player;", "message", "Lnet/minecraft/network/chat/Component;", "", "tell", "Lnet/minecraft/world/entity/LivingEntity;", "isTrue", "(Ljava/lang/Boolean;)Z", "isNotTrue", "isNotEmpty", "Lnet/minecraft/world/item/ItemStack;", "getDyeName", "Lnet/minecraft/world/item/DyeColor;", "getDirectionName", "Lnet/minecraft/core/Direction;", "isItem", "item", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/item/Item;", "tag", "Lnet/minecraft/tags/TagKey;", "isHolder", "T", "location", "Lnet/minecraft/resources/ResourceLocation;", "resourceKey", "Lnet/minecraft/resources/ResourceKey;", "tagKey", "isBlock", "Lnet/minecraft/world/level/block/state/BlockBehaviour$BlockStateBase;", "block", "Lnet/minecraft/world/level/block/Block;", "blockHolder", "isDamageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "Lnet/minecraft/world/damagesource/DamageType;", "isEntity", "Lnet/minecraft/world/entity/EntityType;", "asIngredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "Lnet/minecraft/world/level/ItemLike;", "nextRange", "", "Lnet/minecraft/util/RandomSource;", "min", "max", "", "", "chance", "", "toDegrees", "toRadians", "withComponent", "componentType", "Lnet/minecraft/core/component/DataComponentType;", "component", "(Lnet/minecraft/world/level/ItemLike;Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Lnet/minecraft/world/item/ItemStack;", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Lnet/minecraft/world/item/ItemStack;", "getUuidOrNull", "Ljava/util/UUID;", "Lnet/minecraft/nbt/CompoundTag;", "key", "toVec3", "Lnet/minecraft/world/phys/Vec3;", "Lnet/minecraft/core/Vec3i;", "cast", "(Ljava/lang/Object;)Ljava/lang/Object;", "withHoverText", "Lnet/minecraft/network/chat/Style;", "text", "withClickToRunCommand", "command", "withClickToSuggestCommand", "withClickToOpenUrl", "url", "withClickToCopyToClipboard", "defaultBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/neoforged/neoforge/registries/DeferredBlock;", "aaron-1.21.1"})
public final class AaronExtensions {
    @NotNull
    public static final AaronExtensions INSTANCE = new AaronExtensions();

    private AaronExtensions() {
    }

    public final boolean isServerSide(@NotNull Level $this$isServerSide) {
        Intrinsics.checkNotNullParameter((Object)$this$isServerSide, (String)"<this>");
        return !$this$isServerSide.isClientSide;
    }

    public final boolean isClientSide(@NotNull Entity $this$isClientSide) {
        Intrinsics.checkNotNullParameter((Object)$this$isClientSide, (String)"<this>");
        return $this$isClientSide.level().isClientSide;
    }

    public final boolean isServerSide(@NotNull Entity $this$isServerSide) {
        Intrinsics.checkNotNullParameter((Object)$this$isServerSide, (String)"<this>");
        Level level = $this$isServerSide.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        return this.isServerSide(level);
    }

    public final void status(@NotNull Player $this$status, @NotNull Component message) {
        Intrinsics.checkNotNullParameter((Object)$this$status, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        $this$status.displayClientMessage(message, true);
    }

    public final void status(@NotNull Player $this$status, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)$this$status, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MutableComponent mutableComponent = Component.literal((String)message);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        this.status($this$status, (Component)mutableComponent);
    }

    public final void tell(@NotNull LivingEntity $this$tell, @NotNull Component message) {
        Intrinsics.checkNotNullParameter((Object)$this$tell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        $this$tell.sendSystemMessage(message);
    }

    public final void tell(@NotNull LivingEntity $this$tell, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)$this$tell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MutableComponent mutableComponent = Component.literal((String)message);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        this.tell($this$tell, (Component)mutableComponent);
    }

    public final boolean isTrue(@Nullable Boolean $this$isTrue) {
        return Intrinsics.areEqual((Object)$this$isTrue, (Object)true);
    }

    public final boolean isNotTrue(@Nullable Boolean $this$isNotTrue) {
        return !Intrinsics.areEqual((Object)$this$isNotTrue, (Object)true);
    }

    public final boolean isNotEmpty(@NotNull ItemStack $this$isNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotEmpty, (String)"<this>");
        return !$this$isNotEmpty.isEmpty();
    }

    @NotNull
    public final String getDyeName(@NotNull DyeColor $this$getDyeName) {
        Intrinsics.checkNotNullParameter((Object)$this$getDyeName, (String)"<this>");
        String string = $this$getDyeName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public final String getDirectionName(@NotNull Direction $this$getDirectionName) {
        Intrinsics.checkNotNullParameter((Object)$this$getDirectionName, (String)"<this>");
        String string = $this$getDirectionName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public final boolean isItem(@NotNull ItemStack $this$isItem, @NotNull Holder<Item> item) {
        Intrinsics.checkNotNullParameter((Object)$this$isItem, (String)"<this>");
        Intrinsics.checkNotNullParameter(item, (String)"item");
        return $this$isItem.is(item);
    }

    public final boolean isItem(@NotNull ItemStack $this$isItem, @NotNull Item item) {
        Intrinsics.checkNotNullParameter((Object)$this$isItem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return $this$isItem.is(item);
    }

    public final boolean isItem(@NotNull ItemStack $this$isItem, @NotNull TagKey<Item> tag) {
        Intrinsics.checkNotNullParameter((Object)$this$isItem, (String)"<this>");
        Intrinsics.checkNotNullParameter(tag, (String)"tag");
        return $this$isItem.is(tag);
    }

    public final <T> boolean isHolder(@NotNull Holder<T> $this$isHolder, @NotNull ResourceLocation location) {
        Intrinsics.checkNotNullParameter($this$isHolder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return $this$isHolder.is(location);
    }

    public final <T> boolean isHolder(@NotNull Holder<T> $this$isHolder, @NotNull ResourceKey<T> resourceKey) {
        Intrinsics.checkNotNullParameter($this$isHolder, (String)"<this>");
        Intrinsics.checkNotNullParameter(resourceKey, (String)"resourceKey");
        return $this$isHolder.is(resourceKey);
    }

    public final <T> boolean isHolder(@NotNull Holder<T> $this$isHolder, @NotNull TagKey<T> tagKey) {
        Intrinsics.checkNotNullParameter($this$isHolder, (String)"<this>");
        Intrinsics.checkNotNullParameter(tagKey, (String)"tagKey");
        return $this$isHolder.is(tagKey);
    }

    public final boolean isBlock(@NotNull BlockBehaviour.BlockStateBase $this$isBlock, @NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)$this$isBlock, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return $this$isBlock.is(block);
    }

    public final boolean isBlock(@NotNull BlockBehaviour.BlockStateBase $this$isBlock, @NotNull Holder<Block> blockHolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isBlock, (String)"<this>");
        Intrinsics.checkNotNullParameter(blockHolder, (String)"blockHolder");
        return $this$isBlock.is(blockHolder);
    }

    public final boolean isBlock(@NotNull BlockBehaviour.BlockStateBase $this$isBlock, @NotNull ResourceKey<Block> resourceKey) {
        Intrinsics.checkNotNullParameter((Object)$this$isBlock, (String)"<this>");
        Intrinsics.checkNotNullParameter(resourceKey, (String)"resourceKey");
        return $this$isBlock.is(resourceKey);
    }

    public final boolean isBlock(@NotNull BlockBehaviour.BlockStateBase $this$isBlock, @NotNull TagKey<Block> tagKey) {
        Intrinsics.checkNotNullParameter((Object)$this$isBlock, (String)"<this>");
        Intrinsics.checkNotNullParameter(tagKey, (String)"tagKey");
        return $this$isBlock.is(tagKey);
    }

    public final boolean isDamageSource(@NotNull DamageSource $this$isDamageSource, @NotNull TagKey<DamageType> tagKey) {
        Intrinsics.checkNotNullParameter((Object)$this$isDamageSource, (String)"<this>");
        Intrinsics.checkNotNullParameter(tagKey, (String)"tagKey");
        return $this$isDamageSource.is(tagKey);
    }

    public final boolean isDamageSource(@NotNull DamageSource $this$isDamageSource, @NotNull ResourceKey<DamageType> resourceKey) {
        Intrinsics.checkNotNullParameter((Object)$this$isDamageSource, (String)"<this>");
        Intrinsics.checkNotNullParameter(resourceKey, (String)"resourceKey");
        return $this$isDamageSource.is(resourceKey);
    }

    public final boolean isEntity(@NotNull EntityType<?> $this$isEntity, @NotNull TagKey<EntityType<?>> tagKey) {
        Intrinsics.checkNotNullParameter($this$isEntity, (String)"<this>");
        Intrinsics.checkNotNullParameter(tagKey, (String)"tagKey");
        return $this$isEntity.is(tagKey);
    }

    public final boolean isEntity(@NotNull Entity $this$isEntity, @NotNull TagKey<EntityType<?>> tagKey) {
        Intrinsics.checkNotNullParameter((Object)$this$isEntity, (String)"<this>");
        Intrinsics.checkNotNullParameter(tagKey, (String)"tagKey");
        return $this$isEntity.getType().is(tagKey);
    }

    @NotNull
    public final Ingredient asIngredient(@NotNull ItemLike $this$asIngredient) {
        Intrinsics.checkNotNullParameter((Object)$this$asIngredient, (String)"<this>");
        ItemLike[] itemLikeArray = new ItemLike[]{$this$asIngredient};
        Ingredient ingredient = Ingredient.of((ItemLike[])itemLikeArray);
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
        return ingredient;
    }

    @NotNull
    public final Ingredient asIngredient(@NotNull TagKey<Item> $this$asIngredient) {
        Intrinsics.checkNotNullParameter($this$asIngredient, (String)"<this>");
        Ingredient ingredient = Ingredient.of($this$asIngredient);
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
        return ingredient;
    }

    public final float nextRange(@NotNull RandomSource $this$nextRange, float min, float max) {
        Intrinsics.checkNotNullParameter((Object)$this$nextRange, (String)"<this>");
        return Mth.lerp((float)$this$nextRange.nextFloat(), (float)min, (float)max);
    }

    public final double nextRange(@NotNull RandomSource $this$nextRange, double min, double max) {
        Intrinsics.checkNotNullParameter((Object)$this$nextRange, (String)"<this>");
        return Mth.lerp((double)$this$nextRange.nextDouble(), (double)min, (double)max);
    }

    public final int nextRange(@NotNull RandomSource $this$nextRange, int min, int max) {
        Intrinsics.checkNotNullParameter((Object)$this$nextRange, (String)"<this>");
        return $this$nextRange.nextInt(max - min) + min;
    }

    public final boolean chance(@NotNull RandomSource $this$chance, @NotNull Number chance) {
        Intrinsics.checkNotNullParameter((Object)$this$chance, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)chance, (String)"chance");
        return $this$chance.nextDouble() <= chance.doubleValue();
    }

    public final double toDegrees(@NotNull Number $this$toDegrees) {
        Intrinsics.checkNotNullParameter((Object)$this$toDegrees, (String)"<this>");
        return Math.toDegrees($this$toDegrees.doubleValue());
    }

    public final double toRadians(@NotNull Number $this$toRadians) {
        Intrinsics.checkNotNullParameter((Object)$this$toRadians, (String)"<this>");
        return Math.toRadians($this$toRadians.doubleValue());
    }

    @NotNull
    public final <T> ItemStack withComponent(@NotNull ItemLike $this$withComponent, @NotNull DataComponentType<T> componentType, T component) {
        Intrinsics.checkNotNullParameter((Object)$this$withComponent, (String)"<this>");
        Intrinsics.checkNotNullParameter(componentType, (String)"componentType");
        ItemStack stack = $this$withComponent.asItem().getDefaultInstance();
        stack.set(componentType, component);
        Intrinsics.checkNotNull((Object)stack);
        return stack;
    }

    @NotNull
    public final <T> ItemStack withComponent(@NotNull ItemStack $this$withComponent, @NotNull DataComponentType<T> componentType, T component) {
        Intrinsics.checkNotNullParameter((Object)$this$withComponent, (String)"<this>");
        Intrinsics.checkNotNullParameter(componentType, (String)"componentType");
        $this$withComponent.set(componentType, component);
        return $this$withComponent;
    }

    @Nullable
    public final UUID getUuidOrNull(@NotNull CompoundTag $this$getUuidOrNull, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$getUuidOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return $this$getUuidOrNull.hasUUID(key) ? $this$getUuidOrNull.getUUID(key) : null;
    }

    @NotNull
    public final Vec3 toVec3(@NotNull Vec3i $this$toVec3) {
        Intrinsics.checkNotNullParameter((Object)$this$toVec3, (String)"<this>");
        return new Vec3((double)$this$toVec3.getX(), (double)$this$toVec3.getY(), (double)$this$toVec3.getZ());
    }

    public final <T> T cast(@Nullable Object $this$cast) {
        return (T)$this$cast;
    }

    @NotNull
    public final Style withHoverText(@NotNull Style $this$withHoverText, @NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)$this$withHoverText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Style style = $this$withHoverText.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)component));
        Intrinsics.checkNotNullExpressionValue((Object)style, (String)"withHoverEvent(...)");
        return style;
    }

    @NotNull
    public final Style withHoverText(@NotNull Style $this$withHoverText, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$withHoverText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        MutableComponent mutableComponent = Component.literal((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        return this.withHoverText($this$withHoverText, (Component)mutableComponent);
    }

    @NotNull
    public final Style withClickToRunCommand(@NotNull Style $this$withClickToRunCommand, @NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)$this$withClickToRunCommand, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Style style = $this$withClickToRunCommand.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
        Intrinsics.checkNotNullExpressionValue((Object)style, (String)"withClickEvent(...)");
        return style;
    }

    @NotNull
    public final Style withClickToSuggestCommand(@NotNull Style $this$withClickToSuggestCommand, @NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)$this$withClickToSuggestCommand, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Style style = $this$withClickToSuggestCommand.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command));
        Intrinsics.checkNotNullExpressionValue((Object)style, (String)"withClickEvent(...)");
        return style;
    }

    @NotNull
    public final Style withClickToOpenUrl(@NotNull Style $this$withClickToOpenUrl, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)$this$withClickToOpenUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Style style = $this$withClickToOpenUrl.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        Intrinsics.checkNotNullExpressionValue((Object)style, (String)"withClickEvent(...)");
        return style;
    }

    @NotNull
    public final Style withClickToCopyToClipboard(@NotNull Style $this$withClickToCopyToClipboard, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$withClickToCopyToClipboard, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Style style = $this$withClickToCopyToClipboard.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text));
        Intrinsics.checkNotNullExpressionValue((Object)style, (String)"withClickEvent(...)");
        return style;
    }

    @NotNull
    public final BlockState defaultBlockState(@NotNull DeferredBlock<?> $this$defaultBlockState) {
        Intrinsics.checkNotNullParameter($this$defaultBlockState, (String)"<this>");
        BlockState blockState = ((Block)$this$defaultBlockState.get()).defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
        return blockState;
    }
}

