/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge;

import com.buuz135.replication.block.MatterPipeBlock;
import com.buuz135.replication.network.DefaultMatterNetworkElement;
import com.hrznstudio.titanium.block_network.element.NetworkElementFactory;
import com.hrznstudio.titanium.block_network.element.NetworkElementRegistry;
import com.leclowndu93150.replication_rs2_bridge.Config;
import com.leclowndu93150.replication_rs2_bridge.RepRS2BridgeCapabilities;
import com.leclowndu93150.replication_rs2_bridge.block.ModBlocks;
import com.leclowndu93150.replication_rs2_bridge.block.entity.ModBlockEntities;
import com.leclowndu93150.replication_rs2_bridge.block.entity.RepRS2BridgeBlockEntity;
import com.leclowndu93150.replication_rs2_bridge.component.ModDataComponents;
import com.leclowndu93150.replication_rs2_bridge.item.ModCreativeTabs;
import com.leclowndu93150.replication_rs2_bridge.item.ModItems;
import com.leclowndu93150.replication_rs2_bridge.menu.ModMenus;
import com.leclowndu93150.replication_rs2_bridge.util.MatterTypeUtil;
import com.mojang.logging.LogUtils;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.slf4j.Logger;

@Mod(value="replication_rs2_bridge")
public class ReplicationRSBridge {
    public static final String MODID = "replication_rs2_bridge";
    private static final Logger LOGGER = LogUtils.getLogger();

    public ReplicationRSBridge(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        ModDataComponents.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModMenus.register(modEventBus);
        modEventBus.addListener(this::registerCapabilities);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            if (!ModList.get().isLoaded("replication") || !ModList.get().isLoaded("refinedstorage")) {
                NetworkElementRegistry.INSTANCE.addFactory(DefaultMatterNetworkElement.ID, (NetworkElementFactory)new DefaultMatterNetworkElement.Factory());
            }
        });
        event.enqueueWork(this::registerWithReplicationMod);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        RepRS2BridgeBlockEntity.setWorldUnloading(false);
        MatterTypeUtil.setServer(event.getServer());
        MatterTypeUtil.loadAllMatters(event.getServer());
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        RepRS2BridgeBlockEntity.setWorldUnloading(true);
    }

    private void registerWithReplicationMod() {
        MatterPipeBlock.ALLOWED_CONNECTION_BLOCKS.add(block -> block.getClass().getName().contains(MODID));
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        RepRS2BridgeCapabilities.register(event);
    }

    @EventBusSubscriber(modid="replication_rs2_bridge", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

