/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge.block.entity.storage;

import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.network.MatterNetwork;
import com.leclowndu93150.replication_rs2_bridge.block.entity.RepRS2BridgeBlockEntity;
import com.leclowndu93150.replication_rs2_bridge.block.entity.task.ReplicationTaskHandler;
import com.leclowndu93150.replication_rs2_bridge.component.MatterComponent;
import com.leclowndu93150.replication_rs2_bridge.component.ModDataComponents;
import com.leclowndu93150.replication_rs2_bridge.item.ModItems;
import com.leclowndu93150.replication_rs2_bridge.item.UniversalMatterItem;
import com.leclowndu93150.replication_rs2_bridge.util.MatterTypeUtil;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.composite.CompositeAwareChild;
import com.refinedmods.refinedstorage.api.storage.composite.ParentComposite;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class MatterItemsStorage
implements Storage,
CompositeAwareChild {
    private final RepRS2BridgeBlockEntity owner;
    private final ReplicationTaskHandler taskHandler;
    private ParentComposite parentComposite;
    private final Map<ResourceKey, Long> cachedAmounts = new HashMap<ResourceKey, Long>();

    public MatterItemsStorage(RepRS2BridgeBlockEntity owner, ReplicationTaskHandler taskHandler) {
        this.owner = owner;
        this.taskHandler = taskHandler;
    }

    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        return 0L;
    }

    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        IMatterType matterType;
        ItemStack stack;
        MatterComponent component;
        MatterNetwork network;
        ItemResource itemResource;
        Item item;
        if (!this.owner.isBridgeInitialized()) {
            return 0L;
        }
        if (actor instanceof PlayerActor) {
            return 0L;
        }
        if (resource instanceof ItemResource && (item = (itemResource = (ItemResource)resource).item()) == ModItems.UNIVERSAL_MATTER.get() && (network = this.owner.getNetwork()) != null && (component = (MatterComponent)(stack = itemResource.toItemStack(1L)).get((DataComponentType)ModDataComponents.MATTER.get())) != null && (matterType = MatterTypeUtil.getMatterTypeFromComponent(component)) != null) {
            long available = network.calculateMatterAmount(matterType);
            return Math.min(amount, available);
        }
        return 0L;
    }

    public long extractVirtual(Item item, long amount) {
        return item == ModItems.UNIVERSAL_MATTER.get() ? amount : 0L;
    }

    public Collection<ResourceAmount> getAll() {
        if (!this.owner.isBridgeInitialized()) {
            return List.of();
        }
        MatterNetwork network = this.owner.getNetwork();
        if (network == null) {
            return List.of();
        }
        ArrayList<ResourceAmount> amounts = new ArrayList<ResourceAmount>();
        ArrayList matterTypes = new ArrayList(ReplicationRegistry.MATTER_TYPES_REGISTRY.stream().toList());
        Map<IMatterType, Long> totalAllocated = this.taskHandler.summarizeAllocatedMatter();
        for (IMatterType matterType : matterTypes) {
            ItemStack matterStack;
            long allocated;
            long amount = network.calculateMatterAmount(matterType);
            long available = amount - (allocated = totalAllocated.getOrDefault(matterType, 0L).longValue());
            if (available <= 0L || (matterStack = UniversalMatterItem.createMatterStack(matterType, 1)).isEmpty()) continue;
            ItemResource resource = ItemResource.ofItemStack((ItemStack)matterStack);
            amounts.add(new ResourceAmount((ResourceKey)resource, available));
        }
        return amounts;
    }

    public long getStored() {
        return this.getAll().stream().mapToLong(ResourceAmount::amount).sum();
    }

    public void onAddedIntoComposite(ParentComposite parentComposite) {
        this.parentComposite = parentComposite;
        this.cachedAmounts.clear();
        for (ResourceAmount amount : this.getAll()) {
            this.cachedAmounts.put(amount.resource(), amount.amount());
        }
    }

    public void onRemovedFromComposite(ParentComposite parentComposite) {
        this.parentComposite = null;
        this.cachedAmounts.clear();
    }

    public CompositeAwareChild.Amount compositeInsert(ResourceKey resource, long amount, Action action, Actor actor) {
        return CompositeAwareChild.Amount.ZERO;
    }

    public CompositeAwareChild.Amount compositeExtract(ResourceKey resource, long amount, Action action, Actor actor) {
        long extracted = this.extract(resource, amount, action, actor);
        if (extracted == 0L) {
            return CompositeAwareChild.Amount.ZERO;
        }
        return new CompositeAwareChild.Amount(extracted, extracted);
    }

    public void refreshCache() {
        long previous;
        if (this.parentComposite == null || this.owner.getLevel() == null || this.owner.getLevel().isClientSide()) {
            return;
        }
        HashMap<ResourceKey, Long> latest = new HashMap<ResourceKey, Long>();
        for (ResourceAmount resourceAmount : this.getAll()) {
            latest.put(resourceAmount.resource(), resourceAmount.amount());
        }
        for (Map.Entry entry : latest.entrySet()) {
            previous = this.cachedAmounts.getOrDefault(entry.getKey(), 0L);
            long delta = (Long)entry.getValue() - previous;
            if (delta > 0L) {
                this.parentComposite.addToCache((ResourceKey)entry.getKey(), delta);
                continue;
            }
            if (delta >= 0L) continue;
            this.parentComposite.removeFromCache((ResourceKey)entry.getKey(), -delta);
        }
        for (ResourceKey resourceKey : new HashSet<ResourceKey>(this.cachedAmounts.keySet())) {
            if (latest.containsKey(resourceKey) || (previous = this.cachedAmounts.get(resourceKey).longValue()) <= 0L) continue;
            this.parentComposite.removeFromCache(resourceKey, previous);
        }
        this.cachedAmounts.clear();
        this.cachedAmounts.putAll(latest);
    }
}

