/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge.util;

import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.leclowndu93150.replication_rs2_bridge.component.MatterComponent;
import com.leclowndu93150.replication_rs2_bridge.util.MatterComponentRegistry;
import com.leclowndu93150.replication_rs2_bridge.util.MatterTypeInfo;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class MatterTypeUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, MatterTypeInfo> MATTER_CACHE = new HashMap<String, MatterTypeInfo>();
    private static final Map<IMatterType, MatterTypeInfo> MATTER_BY_TYPE = new HashMap<IMatterType, MatterTypeInfo>();
    private static MinecraftServer cachedServer = null;

    public static void setServer(MinecraftServer server) {
        cachedServer = server;
    }

    public static void loadAllMatters() {
        MatterTypeUtil.loadAllMatters(cachedServer);
    }

    public static void loadAllMatters(MinecraftServer server) {
        MATTER_CACHE.clear();
        MATTER_BY_TYPE.clear();
        try {
            Registry registry = ReplicationRegistry.MATTER_TYPES_REGISTRY;
            if (registry == null) {
                LOGGER.warn("RepRS2Bridge: Matter type registry not ready, skipping texture registration for now.");
                return;
            }
            MatterComponentRegistry componentRegistry = server != null ? MatterComponentRegistry.get(server) : null;
            for (Map.Entry entry : registry.entrySet()) {
                ResourceLocation id = ((ResourceKey)entry.getKey()).location();
                IMatterType matterType = (IMatterType)entry.getValue();
                String name = matterType.getName();
                ResourceLocation texture = MatterTypeUtil.resolveTexture(id, name);
                MatterComponent canonicalComponent = componentRegistry != null ? componentRegistry.getOrCreate(name, texture) : new MatterComponent(name, texture);
                MatterTypeInfo info = new MatterTypeInfo(name, texture, null, id, matterType, canonicalComponent);
                MATTER_CACHE.put(name, info);
                MATTER_BY_TYPE.put(matterType, info);
                if (id.getNamespace().equals("replication")) continue;
                LOGGER.info("RepRS2Bridge: Loaded custom matter '{}' from mod '{}' with texture '{}'", new Object[]{name, id.getNamespace(), texture});
            }
            LOGGER.info("RepRS2Bridge: Loaded {} matter types.", (Object)MATTER_CACHE.size());
        }
        catch (Exception e) {
            LOGGER.error("RepRS2Bridge: Failed to load matter types", (Throwable)e);
        }
    }

    private static ResourceLocation resolveTexture(ResourceLocation id, String name) {
        return ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("gui/mattertypes/" + name.toLowerCase()));
    }

    public static Map<String, MatterTypeInfo> getAllMatters() {
        if (MATTER_CACHE.isEmpty()) {
            MatterTypeUtil.loadAllMatters();
        }
        return new HashMap<String, MatterTypeInfo>(MATTER_CACHE);
    }

    public static MatterTypeInfo getMatterInfo(String matterTypeName) {
        if (MATTER_CACHE.isEmpty()) {
            MatterTypeUtil.loadAllMatters();
        }
        return MATTER_CACHE.get(matterTypeName);
    }

    public static MatterTypeInfo getMatterInfo(IMatterType matterType) {
        if (MATTER_CACHE.isEmpty()) {
            MatterTypeUtil.loadAllMatters();
        }
        return MATTER_BY_TYPE.get(matterType);
    }

    public static IMatterType getMatterTypeFromComponent(MatterComponent component) {
        MatterTypeInfo info;
        if (component == null) {
            return null;
        }
        if (MATTER_CACHE.isEmpty()) {
            MatterTypeUtil.loadAllMatters();
        }
        return (info = MATTER_CACHE.get(component.matterTypeName())) != null ? info.matterType() : null;
    }
}

