/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.ftb.mods.ftbunearthed.entity.Worker;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.layers.CrossedArmsItemLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class WorkerRenderer
extends VillagerRenderer {
    public WorkerRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.layers.removeIf(layer -> layer instanceof CrossedArmsItemLayer);
        this.addLayer(new AnimatedToolLayer(this, ctx.getItemInHandRenderer()));
    }

    private static class AnimatedToolLayer
    extends RenderLayer<Villager, VillagerModel<Villager>> {
        private final ItemInHandRenderer itemInHandRenderer;

        public AnimatedToolLayer(WorkerRenderer workerRenderer, ItemInHandRenderer itemInHandRenderer) {
            super((RenderLayerParent)workerRenderer);
            this.itemInHandRenderer = itemInHandRenderer;
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Villager livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            Worker w;
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.4f, -0.4f);
            if (livingEntity instanceof Worker && (w = (Worker)livingEntity).isBusy()) {
                poseStack.mulPose(Axis.YP.rotationDegrees(this.getBrushRotation((LivingEntity)livingEntity, partialTick) + 90.0f));
                poseStack.translate(0.0f, -0.1f, 0.0f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(-60.0f));
            } else {
                poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            }
            ItemStack itemstack = livingEntity.getItemBySlot(EquipmentSlot.MAINHAND);
            this.itemInHandRenderer.renderItem((LivingEntity)livingEntity, itemstack, ItemDisplayContext.GROUND, false, poseStack, buffer, packedLight);
            poseStack.popPose();
        }

        private float getBrushRotation(LivingEntity e, float partialTick) {
            float t = ((float)(e.tickCount % 20) + partialTick) / 20.0f * ((float)Math.PI * 2);
            return Mth.sin((float)t) * 40.0f;
        }
    }
}

