/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.datagen;

import dev.ftb.mods.ftbunearthed.datagen.BlockStatesGenerator;
import dev.ftb.mods.ftbunearthed.datagen.BlockTagsGenerator;
import dev.ftb.mods.ftbunearthed.datagen.ItemModelsGenerator;
import dev.ftb.mods.ftbunearthed.datagen.ItemTagsGenerator;
import dev.ftb.mods.ftbunearthed.datagen.LangGenerator;
import dev.ftb.mods.ftbunearthed.datagen.LootTablesGenerator;
import dev.ftb.mods.ftbunearthed.datagen.RecipesGenerator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new LangGenerator(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStatesGenerator(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelsGenerator(packOutput, existingFileHelper));
        CompletableFuture lookupProvider = event.getLookupProvider();
        BlockTagsGenerator blockTagsProvider = new BlockTagsGenerator(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagsGenerator(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipesGenerator(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTablesGenerator(packOutput, lookupProvider));
    }
}

