/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.fluid.data;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function6;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public interface ClientFluidProperties {
    public ResourceLocation still(@Nullable BlockAndTintGetter var1, @Nullable BlockPos var2, @Nullable FluidState var3);

    public ResourceLocation flowing(@Nullable BlockAndTintGetter var1, @Nullable BlockPos var2, @Nullable FluidState var3);

    public ResourceLocation overlay(@Nullable BlockAndTintGetter var1, @Nullable BlockPos var2, @Nullable FluidState var3);

    public ResourceLocation screenOverlay();

    default public void renderOverlay(Minecraft minecraft, PoseStack stack) {
        ResourceLocation texture = this.screenOverlay();
        if (texture != null) {
            LocalPlayer player = minecraft.player;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            BlockPos blockpos = BlockPos.containing((double)player.getX(), (double)player.getEyeY(), (double)player.getZ());
            float brightness = LightTexture.getBrightness((DimensionType)player.level().dimensionType(), (int)player.level().getMaxLocalRawBrightness(blockpos));
            BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)0.1f);
            float f7 = -player.getYRot() / 64.0f;
            float f8 = player.getXRot() / 64.0f;
            Matrix4f matrix4f = stack.last().pose();
            bufferbuilder.addVertex(matrix4f, -1.0f, -1.0f, -0.5f).setUv(4.0f + f7, 4.0f + f8);
            bufferbuilder.addVertex(matrix4f, 1.0f, -1.0f, -0.5f).setUv(0.0f + f7, 4.0f + f8);
            bufferbuilder.addVertex(matrix4f, 1.0f, 1.0f, -0.5f).setUv(0.0f + f7, 0.0f + f8);
            bufferbuilder.addVertex(matrix4f, -1.0f, 1.0f, -0.5f).setUv(4.0f + f7, 0.0f + f8);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
    }

    public int tintColor(@Nullable BlockAndTintGetter var1, @Nullable BlockPos var2, @Nullable FluidState var3);

    default public boolean renderFluid(BlockPos pos, BlockAndTintGetter world, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState, Function<ResourceLocation, TextureAtlasSprite> sprites) {
        return false;
    }

    default public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
        return fluidFogColor;
    }

    default public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Function3<BlockAndTintGetter, BlockPos, FluidState, ResourceLocation> still = (a, b, c) -> null;
        private Function3<BlockAndTintGetter, BlockPos, FluidState, ResourceLocation> flowing = (a, b, c) -> null;
        private Function3<BlockAndTintGetter, BlockPos, FluidState, ResourceLocation> overlay = (a, b, c) -> null;
        private ResourceLocation screenOverlay = null;
        private Function3<BlockAndTintGetter, BlockPos, FluidState, Integer> tintColor = (a, b, c) -> -1;
        private Function6<BlockPos, BlockAndTintGetter, VertexConsumer, BlockState, FluidState, Function<ResourceLocation, TextureAtlasSprite>, Boolean> renderFluid = (a, b, c, d, e, f) -> false;

        public Builder still(ResourceLocation still) {
            this.still = (a, b, c) -> still;
            return this;
        }

        public Builder flowing(ResourceLocation flowing) {
            this.flowing = (a, b, c) -> flowing;
            return this;
        }

        public Builder overlay(ResourceLocation overlay) {
            this.overlay = (a, b, c) -> overlay;
            return this;
        }

        public Builder screenOverlay(ResourceLocation screenOverlay) {
            this.screenOverlay = screenOverlay;
            return this;
        }

        public Builder tintColor(Function3<BlockAndTintGetter, BlockPos, FluidState, Integer> tintColor) {
            this.tintColor = tintColor;
            return this;
        }

        public Builder tintColor(int tintColor) {
            this.tintColor = (a, b, c) -> tintColor;
            return this;
        }

        public Builder renderFluid(Function6<BlockPos, BlockAndTintGetter, VertexConsumer, BlockState, FluidState, Function<ResourceLocation, TextureAtlasSprite>, Boolean> renderFluid) {
            this.renderFluid = renderFluid;
            return this;
        }

        public ClientFluidProperties build() {
            return new ClientFluidProperties(){

                @Override
                public ResourceLocation still(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, @Nullable FluidState state) {
                    return (ResourceLocation)still.apply((Object)view, (Object)pos, (Object)state);
                }

                @Override
                public ResourceLocation flowing(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, @Nullable FluidState state) {
                    return (ResourceLocation)flowing.apply((Object)view, (Object)pos, (Object)state);
                }

                @Override
                public ResourceLocation overlay(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, @Nullable FluidState state) {
                    return (ResourceLocation)overlay.apply((Object)view, (Object)pos, (Object)state);
                }

                @Override
                public ResourceLocation screenOverlay() {
                    return screenOverlay;
                }

                @Override
                public int tintColor(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, @Nullable FluidState state) {
                    return (Integer)tintColor.apply((Object)view, (Object)pos, (Object)state);
                }

                @Override
                public boolean renderFluid(BlockPos pos, BlockAndTintGetter world, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState, Function<ResourceLocation, TextureAtlasSprite> sprites) {
                    return (Boolean)renderFluid.apply((Object)pos, (Object)world, (Object)vertexConsumer, (Object)blockState, (Object)fluidState, sprites);
                }
            };
        }
    }
}

