/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.sdrp;

import com.jagrosh.discordipc.entities.RichPresence;
import com.jagrosh.discordipc.entities.pipe.PipeStatus;
import com.sunekaer.sdrp.config.SDRPConfig;
import com.sunekaer.sdrp.discord.RPClient;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import java.time.OffsetDateTime;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SDRP {
    public static final String MOD_ID = "sdrp";
    public static RPClient RP_CLIENT;
    public static final OffsetDateTime START_TIME;
    public static SDRPConfig config;

    public static void init() {
        ConfigHolder register = AutoConfig.register(SDRPConfig.class, JanksonConfigSerializer::new);
        config = (SDRPConfig)register.getConfig();
        RP_CLIENT = new RPClient();
        ClientLifecycleEvent.CLIENT_STOPPING.register(minecraft -> SDRP.shutdownDiscordClient());
        Runtime.getRuntime().addShutdownHook(new Thread(SDRP::shutdownDiscordClient));
        EntityEvent.ADD.register(SDRP::clientJoinEvent);
        ClientGuiEvent.INIT_POST.register(SDRP::screenEvent);
    }

    private static void screenEvent(Screen screen, ScreenAccess screenAccess) {
        if (!SDRP.config.enabled || !SDRP.config.enableUpdateScreenPresence) {
            return;
        }
        SDRP.updateScreen(screen);
    }

    private static void updateScreen(Screen screen) {
        String screenClassName = screen.getClass().getName();
        Optional<SDRPConfig.ScreenTranslation> screenPresence = SDRP.config.screens.stream().filter(e -> e.screenClass.contains(screenClassName)).findFirst();
        if (screenPresence.isEmpty()) {
            return;
        }
        RichPresence state = screenPresence.get().createPresence();
        RichPresence currentState = RP_CLIENT.getCurrentState();
        if (currentState != state) {
            RP_CLIENT.setState(state);
        }
    }

    private static EventResult clientJoinEvent(Entity entity, Level level) {
        if (!SDRP.config.enabled || !SDRP.config.enableUpdateDimensionPresence) {
            return EventResult.pass();
        }
        if (entity instanceof AbstractClientPlayer && entity.getUUID().equals(Minecraft.getInstance().player.getUUID())) {
            SDRP.setDimension(level, (Player)entity);
        }
        return EventResult.pass();
    }

    public static void setDimension(Level level, Player player) {
        String dimensionName = level.dimension().location().toString();
        for (SDRPConfig.DimensionEntry entry : SDRP.config.dimensionsSupport) {
            if (!entry.matches(dimensionName)) continue;
            RichPresence state = entry.createPresence(level.dimension().location(), player);
            RP_CLIENT.setState(state);
            return;
        }
    }

    private static void shutdownDiscordClient() {
        if (!RPClient.EXECUTOR_SERVICE.isShutdown()) {
            RPClient.EXECUTOR_SERVICE.shutdown();
        }
        if (RP_CLIENT == null || RP_CLIENT.getClient() == null || RP_CLIENT.getClient().getStatus() != PipeStatus.CONNECTED) {
            return;
        }
        RP_CLIENT.getClient().close();
    }

    static {
        START_TIME = OffsetDateTime.now();
    }
}

