/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.client.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import cy.jdkdigital.trophymanager.common.blockentity.TrophyBlockEntity;
import cy.jdkdigital.trophymanager.init.ModBlocks;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrophyItemStackRenderer
extends BlockEntityWithoutLevelRenderer {
    WeakReference<TrophyBlockEntity> blockEntity;

    public TrophyItemStackRenderer() {
        super(null, null);
    }

    public void renderByItem(@Nonnull ItemStack stack, @Nonnull ItemDisplayContext transformType, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLightIn, int packedUV) {
        TrophyBlockEntity weakBlockEntity;
        if (!stack.has(DataComponents.CUSTOM_DATA)) {
            return;
        }
        TrophyBlockEntity trophyBlockEntity = weakBlockEntity = this.blockEntity != null ? (TrophyBlockEntity)((Object)this.blockEntity.get()) : null;
        if (weakBlockEntity == null) {
            this.blockEntity = new WeakReference<TrophyBlockEntity>(new TrophyBlockEntity(BlockPos.ZERO, ((Block)ModBlocks.TROPHY.get()).defaultBlockState()));
            weakBlockEntity = (TrophyBlockEntity)((Object)this.blockEntity.get());
        }
        if (weakBlockEntity != null) {
            weakBlockEntity.loadData(((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag(), (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
            weakBlockEntity.isOnHead = transformType.equals((Object)ItemDisplayContext.HEAD);
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.translate(-1.0f, 0.0f, -1.0f);
            Minecraft.getInstance().getBlockEntityRenderDispatcher().renderItem((BlockEntity)weakBlockEntity, poseStack, buffer, packedLightIn, packedUV);
            poseStack.popPose();
        }
    }
}

