/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.kineticbridge;

import com.hlysine.create_connected.content.KineticHelper;
import com.hlysine.create_connected.content.kineticbridge.KineticBridgeBlockEntity;
import com.hlysine.create_connected.content.kineticbridge.KineticBridgeDestinationBlock;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class KineticBridgeDestinationBlockEntity
extends GeneratingKineticBlockEntity {
    WeakReference<KineticBridgeBlockEntity> sourceBE = new WeakReference<Object>(null);
    boolean updateKineticsNextTick = false;

    public KineticBridgeDestinationBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private KineticBridgeBlockEntity getSource() {
        KineticBridgeBlockEntity source = (KineticBridgeBlockEntity)((Object)this.sourceBE.get());
        BlockPos sourcePos = KineticBridgeDestinationBlock.getSource(this.getBlockPos(), this.getBlockState());
        if (source != null && !source.isRemoved() && source.getBlockPos().equals((Object)sourcePos)) {
            return source;
        }
        if (this.getLevel() == null) {
            return null;
        }
        BlockEntity be = this.getLevel().getBlockEntity(sourcePos);
        if (!(be instanceof KineticBridgeBlockEntity)) {
            return null;
        }
        KineticBridgeBlockEntity bridgeBE = (KineticBridgeBlockEntity)be;
        this.sourceBE = new WeakReference<KineticBridgeBlockEntity>(bridgeBE);
        return bridgeBE;
    }

    public void tick() {
        super.tick();
        if (!this.getLevel().isClientSide() && this.updateKineticsNextTick) {
            KineticHelper.updateKineticBlock((KineticBlockEntity)this);
            this.updateKineticsNextTick = false;
        }
    }

    public float getGeneratedSpeed() {
        KineticBridgeBlockEntity source = this.getSource();
        if (source == null) {
            return 0.0f;
        }
        return source.getSpeed();
    }

    public float calculateAddedStressCapacity() {
        float capacity = 0.0f;
        KineticBridgeBlockEntity source = this.getSource();
        if (source != null) {
            capacity = source.calculateStressApplied();
        }
        this.lastCapacityProvided = capacity;
        return capacity;
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(1.0);
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putBoolean("UpdateKineticNextTick", this.updateKineticsNextTick);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.updateKineticsNextTick = compound.getBoolean("UpdateKineticNextTick");
    }
}

