/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.entity;

import cy.jdkdigital.utilitarian.module.UtilityEntityModule;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class RisingBlockEntity
extends FallingBlockEntity {
    public RisingBlockEntity(EntityType<? extends FallingBlockEntity> entityType, Level level) {
        super(entityType, level);
    }

    private RisingBlockEntity(Level level, double x, double y, double z, BlockState state) {
        this((EntityType<? extends FallingBlockEntity>)((EntityType)UtilityEntityModule.RISING_BLOCK.get()), level);
        this.blockState = state;
        this.blocksBuilding = true;
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setStartPos(this.blockPosition());
    }

    public static RisingBlockEntity rise(Level level, BlockPos pos, BlockState blockState) {
        RisingBlockEntity risingBlockEntity = new RisingBlockEntity(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.FALSE) : blockState);
        level.setBlock(pos, blockState.getFluidState().createLegacyBlock(), 3);
        level.addFreshEntity((Entity)risingBlockEntity);
        return risingBlockEntity;
    }

    protected double getDefaultGravity() {
        return -0.04;
    }

    public void tick() {
        super.tick();
        if (!this.level().getBlockState(this.blockPosition().above()).isAir()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            this.setPos(this.position().x, this.blockPosition().getY(), this.position().z);
        }
    }
}

