/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.mru.yacl;

import dev.imb11.mru.yacl.EntryType;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ConfigHelper {
    private final String modID;
    private final String configTranslationKey;

    public ConfigHelper(@NotNull String modID, @NotNull String configTranslationKey) {
        this.modID = modID;
        this.configTranslationKey = configTranslationKey;
    }

    @NotNull
    public Component getText(@NotNull EntryType entryType, @NotNull String configOptionName) {
        return Component.translatable((String)String.format("%s.%s.%s.%s", this.modID, this.configTranslationKey, switch (entryType) {
            case EntryType.CATEGORY_NAME -> "category";
            case EntryType.GROUP_NAME -> "group";
            case EntryType.OPTION_NAME -> "option";
            case EntryType.OPTION_DESCRIPTION -> "option.description";
            default -> throw new IllegalArgumentException("TextType is invalid.");
        }, configOptionName));
    }

    @NotNull
    public OptionDescription get(@NotNull String name, boolean withImage) {
        OptionDescription.Builder builder = OptionDescription.createBuilder().text(new Component[]{this.getText(EntryType.OPTION_DESCRIPTION, name)});
        if (withImage) {
            builder = builder.webpImage(ResourceLocation.tryBuild((String)this.modID, (String)("textures/gui/options/" + name.toLowerCase() + ".webp")));
        }
        return builder.build();
    }

    @NotNull
    public Option<Boolean> get(@NotNull String name, boolean defaultValue, Supplier<Boolean> getter, Consumer<Boolean> setter, boolean withImage) {
        return Option.createBuilder().name(this.getText(EntryType.OPTION_NAME, name)).description(this.get(name, withImage)).binding((Object)defaultValue, getter, setter).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true).trueFalseFormatter()).build();
    }

    @NotNull
    public Option<Boolean> get(@NotNull String name, boolean defaultValue, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return this.get(name, defaultValue, getter, setter, false);
    }

    @NotNull
    public Option<String> get(@NotNull String name, String defaultValue, Supplier<String> getter, Consumer<String> setter, boolean withImage) {
        return Option.createBuilder().name(this.getText(EntryType.OPTION_NAME, name)).description(this.get(name, withImage)).binding((Object)defaultValue, getter, setter).controller(StringControllerBuilder::create).build();
    }

    @NotNull
    public Option<String> get(@NotNull String name, String defaultValue, Supplier<String> getter, Consumer<String> setter) {
        return this.get(name, defaultValue, getter, setter, false);
    }

    @NotNull
    public Option<Integer> getField(@NotNull String name, int min, int max, int defaultValue, Supplier<Integer> getter, Consumer<Integer> setter, boolean withImage) {
        return Option.createBuilder().name(this.getText(EntryType.OPTION_NAME, name)).description(this.get(name, withImage)).binding((Object)defaultValue, getter, setter).controller(opt -> ((IntegerFieldControllerBuilder)IntegerFieldControllerBuilder.create((Option)opt).min((Number)min)).max((Number)max)).build();
    }

    @NotNull
    public Option<Integer> getField(@NotNull String name, int min, int max, int defaultValue, Supplier<Integer> getter, Consumer<Integer> setter) {
        return this.getField(name, min, max, defaultValue, getter, setter, false);
    }

    @NotNull
    public Option<Integer> getField(@NotNull String name, int defaultValue, Supplier<Integer> getter, Consumer<Integer> setter, boolean withImage) {
        return this.getField(name, Integer.MIN_VALUE, Integer.MAX_VALUE, defaultValue, getter, setter, withImage);
    }

    @NotNull
    public Option<Integer> getField(@NotNull String name, int defaultValue, Supplier<Integer> getter, Consumer<Integer> setter) {
        return this.getField(name, defaultValue, getter, setter, false);
    }

    @NotNull
    public Option<Integer> getSlider(@NotNull String name, int min, int max, int defaultValue, Supplier<Integer> getter, Consumer<Integer> setter, boolean withImage) {
        return Option.createBuilder().name(this.getText(EntryType.OPTION_NAME, name)).description(this.get(name, withImage)).binding((Object)defaultValue, getter, setter).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)min, (Number)max)).step((Number)1)).build();
    }

    @NotNull
    public Option<Integer> getSlider(@NotNull String name, int min, int max, int defaultValue, Supplier<Integer> getter, Consumer<Integer> setter) {
        return this.getSlider(name, min, max, defaultValue, getter, setter, false);
    }

    @NotNull
    public Option<Float> getField(@NotNull String name, float min, float max, float defaultValue, Supplier<Float> getter, Consumer<Float> setter, boolean withImage) {
        return Option.createBuilder().name(this.getText(EntryType.OPTION_NAME, name)).description(this.get(name, withImage)).binding((Object)Float.valueOf(defaultValue), getter, setter).controller(opt -> ((FloatFieldControllerBuilder)FloatFieldControllerBuilder.create((Option)opt).min((Number)Float.valueOf(min))).max((Number)Float.valueOf(max))).build();
    }

    @NotNull
    public Option<Float> getField(@NotNull String name, float min, float max, float defaultValue, Supplier<Float> getter, Consumer<Float> setter) {
        return this.getField(name, min, max, defaultValue, getter, setter, false);
    }

    @NotNull
    public Option<Float> getField(@NotNull String name, float defaultValue, Supplier<Float> getter, Consumer<Float> setter, boolean withImage) {
        return this.getField(name, Float.MIN_VALUE, Float.MAX_VALUE, defaultValue, getter, setter, withImage);
    }

    @NotNull
    public Option<Float> getField(@NotNull String name, float defaultValue, Supplier<Float> getter, Consumer<Float> setter) {
        return this.getField(name, defaultValue, getter, setter, false);
    }

    @NotNull
    public Option<Float> getSlider(@NotNull String name, float min, float max, float step, float defaultValue, Supplier<Float> getter, Consumer<Float> setter, boolean withImage) {
        return Option.createBuilder().name(this.getText(EntryType.OPTION_NAME, name)).description(this.get(name, withImage)).binding((Object)Float.valueOf(defaultValue), getter, setter).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(min), (Number)Float.valueOf(max))).step((Number)Float.valueOf(step))).build();
    }

    @NotNull
    public Option<Float> getSlider(@NotNull String name, float min, float max, float step, float defaultValue, Supplier<Float> getter, Consumer<Float> setter) {
        return this.getSlider(name, min, max, step, defaultValue, getter, setter, false);
    }

    @NotNull
    public Option<Color> get(@NotNull String name, boolean allowAlpha, Color defaultValue, Supplier<Color> getter, Consumer<Color> setter, boolean withImage) {
        return Option.createBuilder().name(this.getText(EntryType.OPTION_NAME, name)).description(this.get(name, withImage)).binding((Object)defaultValue, getter, setter).controller(opt -> ColorControllerBuilder.create((Option)opt).allowAlpha(allowAlpha)).build();
    }

    @NotNull
    public Option<Color> get(@NotNull String name, boolean allowAlpha, Color defaultValue, Supplier<Color> getter, Consumer<Color> setter) {
        return this.get(name, allowAlpha, defaultValue, getter, setter, false);
    }

    @NotNull
    public Option<Color> get(@NotNull String name, Color defaultValue, Supplier<Color> getter, Consumer<Color> setter, boolean withImage) {
        return this.get(name, false, defaultValue, getter, setter, withImage);
    }

    @NotNull
    public Option<Color> get(@NotNull String name, Color defaultValue, Supplier<Color> getter, Consumer<Color> setter) {
        return this.get(name, false, defaultValue, getter, setter, false);
    }
}

