/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.widgets;

import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.widgets.GuiUtils;
import carbonconfiglib.gui.widgets.Icon;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class CarbonIconButton
extends AbstractButton {
    Consumer<CarbonIconButton> listener;
    Icon icon;
    boolean iconOnly = false;
    int hash;

    public CarbonIconButton(int x, int y, int width, int height, Icon icon, Component name, Consumer<CarbonIconButton> listener) {
        super(x, y, width, height, name);
        this.listener = listener;
        this.icon = icon;
        this.hash = name.getString().hashCode();
    }

    public CarbonIconButton setIconOnly() {
        this.iconOnly = true;
        return this;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float p_93679_) {
        graphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        if (this.iconOnly) {
            int j = this.getFGColor();
            RenderSystem.setShaderColor((float)((float)(j >> 16 & 0xFF) / 255.0f), (float)((float)(j >> 8 & 0xFF) / 255.0f), (float)((float)(j & 0xFF) / 255.0f), (float)1.0f);
            GuiUtils.drawTextureRegion(graphics, (float)(this.getX() + this.width / 2) - 5.5f, (float)(this.getY() + this.height / 2) - 5.5f, 11.0f, 11.0f, this.icon, 16.0f, 16.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        int width = font.width((FormattedText)this.getMessage()) + 21;
        float minX = this.getX() + 4 + this.width / 2 - width / 2;
        int j = this.getFGColor();
        RenderSystem.setShaderColor((float)((float)(j >> 16 & 0xFF) / 255.0f), (float)((float)(j >> 8 & 0xFF) / 255.0f), (float)((float)(j & 0xFF) / 255.0f), (float)1.0f);
        GuiUtils.drawTextureRegion(graphics, minX, this.getY() + (this.height - 8) / 2, 11.0f, 11.0f, this.icon, 16.0f, 16.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiUtils.drawScrollingShadowString(graphics, font, this.getMessage(), minX + 15.0f, this.getY(), width, this.height - 2, ConfigElement.GuiAlign.CENTER, this.getFGColor(), this.hash);
    }

    public void onPress() {
        if (this.listener == null) {
            return;
        }
        this.listener.accept(this);
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
        this.defaultButtonNarrationText(output);
    }
}

