/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.block;

import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityGoldPortal
extends BlockEntity {
    public static final String REG_NAME = "tileentity_gold_portal";
    private double destX = 0.0;
    private double destY = -10000.0;
    private double destZ = 0.0;
    private Direction facing = Direction.NORTH;
    private int cooldown = DungeonConfig.portalCooldownTicks;
    private int lastUpdate = 0;
    private String destDimension = "minecraft:overworld";

    public TileEntityGoldPortal(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistrar.BE_GOLD_PORTAL.get(), pos, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        if (compound.contains("destX") && compound.contains("destY") && compound.contains("destZ")) {
            this.destX = compound.getDouble("destX");
            this.destY = compound.getDouble("destY");
            this.destZ = compound.getDouble("destZ");
        }
        if (compound.contains("cooldown")) {
            this.cooldown = compound.getInt("cooldown");
        }
        this.destDimension = compound.contains("destDimension") ? compound.getString("destDimension") : "minecraft:overworld";
        this.facing = compound.contains("facing") ? Direction.valueOf((String)compound.getString("facing")) : Direction.NORTH;
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putDouble("destX", this.destX);
        compound.putDouble("destY", this.destY);
        compound.putDouble("destZ", this.destZ);
        compound.putInt("cooldown", this.cooldown);
        compound.putString("destDimension", this.destDimension);
        compound.putString("facing", this.facing.name());
    }

    public void setDestination(double posX, double posY, double posZ, String destDim, Direction faceExit) {
        this.destX = posX;
        this.destY = posY;
        this.destZ = posZ;
        this.destDimension = destDim;
        this.facing = faceExit;
    }

    public BlockPos getDestination() {
        return new BlockPos((int)this.destX, (int)this.destY, (int)this.destZ);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public ResourceKey<Level> getDestinationDimension() {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)this.destDimension));
    }

    public Direction getExitDirection() {
        return this.facing;
    }

    public boolean needsUpdateThisTick(int tick) {
        return tick > this.lastUpdate;
    }

    public boolean setCooldown(int value, Level worldIn, BlockPos pos, int currentServerTick) {
        if (this.cooldown == value || currentServerTick <= this.lastUpdate) {
            return false;
        }
        this.cooldown = value;
        this.lastUpdate = currentServerTick;
        int numBlocksUpdated = 0;
        if (worldIn.getBlockEntity(pos.west()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.getBlockEntity(pos.west())).setCooldown(value, worldIn, pos.west(), currentServerTick) ? 1 : 0;
        }
        if (worldIn.getBlockEntity(pos.east()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.getBlockEntity(pos.east())).setCooldown(value, worldIn, pos.east(), currentServerTick) ? 1 : 0;
        }
        if (worldIn.getBlockEntity(pos.north()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.getBlockEntity(pos.north())).setCooldown(value, worldIn, pos.north(), currentServerTick) ? 1 : 0;
        }
        if (worldIn.getBlockEntity(pos.south()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.getBlockEntity(pos.south())).setCooldown(value, worldIn, pos.south(), currentServerTick) ? 1 : 0;
        }
        if (worldIn.getBlockEntity(pos.above()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.getBlockEntity(pos.above())).setCooldown(value, worldIn, pos.above(), currentServerTick) ? 1 : 0;
        }
        if (worldIn.getBlockEntity(pos.below()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.getBlockEntity(pos.below())).setCooldown(value, worldIn, pos.below(), currentServerTick) ? 1 : 0;
        }
        return numBlocksUpdated > 0;
    }
}

