/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.item;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.dimension.PersonalBuildData;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.DungeonKeyDataComponentRecord;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemBlankBuildKey
extends BaseItemKey {
    public static final String REG_NAME = "item_blank_build_key";

    public ItemBlankBuildKey() {
        super(new Item.Properties().rarity(Rarity.COMMON));
    }

    @Override
    public void performActivationRitual(Player player, ItemStack itemstack, Level worldIn, BlockPos pos) {
        worldIn.playSound((Player)null, pos, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (player == null) {
            DimDungeons.logMessageError("Somehow activated a blank personal key without a player present. Do not do this.");
            return;
        }
        if (!worldIn.isClientSide) {
            int slot = player.getInventory().findSlotMatchingItem(itemstack);
            itemstack.shrink(1);
            ItemStack newkey = new ItemStack((ItemLike)ItemRegistrar.ITEM_BUILD_KEY.get());
            this.activateBuildKey(worldIn.getServer(), newkey, (LivingEntity)player);
            if (!player.getInventory().add(slot, newkey) && !player.addItem(newkey)) {
                player.drop(newkey, false);
            }
        }
        this.createActivationParticleEffects(worldIn, pos);
        this.createActivationParticleEffectsForBuildKey(worldIn, pos);
    }

    public void activateBuildKey(MinecraftServer server, ItemStack stack, LivingEntity player) {
        ChunkPos dest = PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(server)).getPosForOwner(player);
        stack.set(DimDungeons.DUNGEON_KEY_DATA, (Object)new DungeonKeyDataComponentRecord(true, false, dest.x, dest.z, 8, 0, 0, 0, DungeonDesigner.DungeonType.PERSONAL_BUILD.toString()));
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"npart.dimdungeons.struct_8", (Object[])new Object[]{Component.literal((String)player.getName().getString()).withStyle(ChatFormatting.DARK_AQUA)}));
    }

    public void createActivationParticleEffectsForBuildKey(Level worldIn, BlockPos pos) {
        RandomSource random = worldIn.getRandom();
        for (int i = 0; i < 8; ++i) {
            double d0 = (float)pos.getX() + 0.5f;
            double d1 = (float)pos.getY() + 0.8f;
            double d2 = (float)pos.getZ() + 0.5f;
            double xspeed = (double)random.nextFloat() * 0.04 * (double)(random.nextBoolean() ? 1 : -1);
            double yspeed = (double)random.nextFloat() * 0.65;
            double zspeed = (double)random.nextFloat() * 0.04 * (double)(random.nextBoolean() ? 1 : -1);
            worldIn.addParticle((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, xspeed, yspeed, zspeed);
        }
    }
}

