/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.structure;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.BlockGoldPortal;
import com.catastrophe573.dimdungeons.block.BlockLocalTeleporter;
import com.catastrophe573.dimdungeons.block.BlockPortalKeyhole;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityGoldPortal;
import com.catastrophe573.dimdungeons.block.TileEntityLocalTeleporter;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.dimension.DungeonData;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.catastrophe573.dimdungeons.structure.DungeonDesignerTeleporterHub;
import com.catastrophe573.dimdungeons.structure.DungeonDesignerThemeOpen;
import com.catastrophe573.dimdungeons.structure.DungeonPlacementDebug;
import com.catastrophe573.dimdungeons.structure.DungeonRoom;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.Filterable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class DungeonPlacement {
    public static int SIGN_Y = 49;

    public static boolean beginDesignAndBuild(ServerLevel world, long x, long z, DungeonGenData genData) {
        DungeonDesigner dbl;
        long entranceChunkZ;
        long entranceChunkX = DungeonPlacement.getEntranceX(x);
        if (!DungeonPlacement.isEntranceChunk(entranceChunkX, entranceChunkZ = DungeonPlacement.getEntranceZ(z))) {
            DimDungeons.logMessageError("DIMDUNGEONS FATAL ERROR: incorrect entrance chunk chosen: " + x + ", " + z);
            return false;
        }
        DimDungeons.logMessageInfo("DIMDUNGEONS START STRUCTURE at chunk: " + x + ", " + z);
        int dungeonSize = 25;
        DungeonDesigner.DungeonType dungeonType = DungeonDesigner.DungeonType.BASIC;
        boolean useLarge = false;
        if (DungeonConfig.enableDebugCheats && DungeonUtils.doesKeyMatchDebugCheat(genData) > 0) {
            return DungeonPlacementDebug.place(world, x, z, DungeonUtils.doesKeyMatchDebugCheat(genData), genData);
        }
        if (genData.dungeonTheme == 2) {
            dungeonType = DungeonDesigner.DungeonType.THEME_OPEN;
            dbl = new DungeonDesignerThemeOpen(world.getRandom(), entranceChunkX, entranceChunkZ, dungeonType, genData.dungeonTheme);
            dungeonSize = DungeonConfig.themeSettings.get((int)(genData.dungeonTheme - 1)).themeDungeonSize;
        } else if (genData.dungeonType == DungeonDesigner.DungeonType.ADVANCED) {
            dungeonType = DungeonDesigner.DungeonType.ADVANCED;
            dbl = new DungeonDesigner(world.getRandom(), entranceChunkX, entranceChunkZ, dungeonType, genData.dungeonTheme);
            dungeonSize = 46;
            useLarge = true;
        } else if (genData.dungeonType == DungeonDesigner.DungeonType.TELEPORTER_HUB) {
            dungeonType = DungeonDesigner.DungeonType.TELEPORTER_HUB;
            dbl = new DungeonDesignerTeleporterHub(world.getRandom(), entranceChunkX, entranceChunkZ, dungeonType, genData.dungeonTheme);
        } else {
            dungeonType = DungeonDesigner.DungeonType.BASIC;
            dbl = new DungeonDesigner(world.getRandom(), entranceChunkX, entranceChunkZ, dungeonType, genData.dungeonTheme);
            if (genData.dungeonTheme > 0) {
                dungeonSize = DungeonConfig.themeSettings.get((int)(genData.dungeonTheme - 1)).themeDungeonSize;
            }
        }
        dbl.calculateDungeonShape(dungeonSize, useLarge);
        DungeonData.get((Level)world).registerNewRooms(dbl, x, z);
        return true;
    }

    public static boolean buildRoomAtChunk(ServerLevel world, ChunkPos cpos) {
        BlockPos bpos = new BlockPos(cpos.getMinBlockX(), SIGN_Y, cpos.getMinBlockZ());
        DungeonRoom nextRoom = DungeonData.get((Level)world).getRoomAtPos(cpos);
        if (nextRoom == null || DungeonPlacement.wasRoomBuiltAtChunk((Level)world, cpos)) {
            return false;
        }
        world.setBlockAndUpdate(bpos.below().below(), Blocks.BEDROCK.defaultBlockState());
        if (nextRoom.roomType == DungeonDesigner.RoomType.LARGE) {
            if (!DungeonPlacement.putLargeRoomHere(cpos, world, nextRoom)) {
                DimDungeons.logMessageError("DIMDUNGEONS ERROR UNABLE TO PLACE ***LARGE*** STRUCTURE: " + nextRoom.structure);
                return false;
            }
            if (nextRoom.dungeonType != DungeonDesigner.DungeonType.TELEPORTER_HUB) {
                DungeonPlacement.closeDoorsOnLargeRoom(cpos, world, nextRoom);
                DungeonPlacement.closeDoorsOnLargeRoom(new ChunkPos(cpos.x + 1, cpos.z), world, nextRoom);
                DungeonPlacement.closeDoorsOnLargeRoom(new ChunkPos(cpos.x, cpos.z + 1), world, nextRoom);
                DungeonPlacement.closeDoorsOnLargeRoom(new ChunkPos(cpos.x + 1, cpos.z + 1), world, nextRoom);
            }
        } else if (nextRoom.roomType != DungeonDesigner.RoomType.LARGE_DUMMY && !DungeonPlacement.putRoomHere(cpos, world, nextRoom)) {
            DimDungeons.logMessageError("DIMDUNGEONS ERROR UNABLE TO PLACE STRUCTURE: " + nextRoom.structure);
        }
        return true;
    }

    public static boolean wasRoomBuiltAtChunk(Level world, ChunkPos cpos) {
        BlockPos bpos;
        ServerLevel dungeonDim = DungeonUtils.getDungeonWorld(world.getServer());
        return dungeonDim.getBlockState(bpos = new BlockPos(cpos.getMinBlockX(), SIGN_Y - 2, cpos.getMinBlockZ())).getBlock() == Blocks.BEDROCK;
    }

    public static boolean isDungeonChunk(long x, long z) {
        if (x < 0L) {
            return false;
        }
        if (z >= 0L) {
            long plotX = x % 16L;
            long plotZ = z % 16L;
            return plotX > 3L && plotX < 12L && plotZ > 3L && plotZ < 12L;
        }
        long plotX = x % 16L;
        long plotZ = z % 16L;
        return plotX > 3L && plotX < 12L && plotZ < -4L && plotZ > -13L;
    }

    public static boolean isEntranceChunk(long x, long z) {
        if (x < 0L) {
            return false;
        }
        if (z >= 0L) {
            long plotX = x % 16L;
            long plotZ = z % 16L;
            return plotX == 8L && plotZ == 11L;
        }
        long plotX = x % 16L;
        long plotZ = z % 16L;
        return plotX == 8L && plotZ == -5L;
    }

    public static long getEntranceX(long chunkX) {
        return chunkX / 16L + 8L;
    }

    public static long getEntranceZ(long chunkZ) {
        if (chunkZ >= 0L) {
            return chunkZ / 16L + 11L;
        }
        return chunkZ / 16L + 11L;
    }

    public static boolean putLargeRoomHere(ChunkPos cpos, ServerLevel world, DungeonRoom room) {
        MinecraftServer minecraftserver = world.getServer();
        StructureTemplateManager templatemanager = DungeonUtils.getDungeonWorld(minecraftserver).getStructureManager();
        StructureTemplate template = templatemanager.getOrCreate(ResourceLocation.parse((String)room.structure));
        StructurePlaceSettings placementsettings = new StructurePlaceSettings().setMirror(Mirror.NONE).setRotation(Rotation.NONE).setIgnoreEntities(false);
        placementsettings.setRotation(Rotation.NONE);
        placementsettings.setBoundingBox(new BoundingBox(cpos.x * 16, 0, cpos.z * 16, cpos.x * 16 + 32 - 1, 255, cpos.z * 16 + 32 - 1));
        BlockPos position = new BlockPos(cpos.getMinBlockX(), 50, cpos.getMinBlockZ());
        BlockPos sizeRange = new BlockPos(32, 13, 32);
        if (template == null) {
            DimDungeons.logMessageError("DIMDUNGEONS FATAL ERROR: LARGE structure does not exist (" + room.structure + ")");
            return false;
        }
        DimDungeons.logMessageInfo("Placing a large room: " + room.structure);
        boolean success = template.placeInWorld((ServerLevelAccessor)world, position, sizeRange, placementsettings, world.getRandom(), 2);
        for (StructureTemplate.StructureBlockInfo template$blockinfo : template.filterBlocks(position, placementsettings, Blocks.STRUCTURE_BLOCK)) {
            StructureMode structuremode;
            if (template$blockinfo.nbt() == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.nbt().getString("mode"))) != StructureMode.DATA) continue;
            DungeonPlacement.handleDataBlock(template$blockinfo.nbt().getString("metadata"), template$blockinfo.pos(), world, world.getRandom(), placementsettings.getBoundingBox(), room);
        }
        return success;
    }

    public static void closeDoorsOnLargeRoom(ChunkPos cpos, ServerLevel world, DungeonRoom room) {
        BlockState fillBlock = Blocks.STONE_BRICKS.defaultBlockState();
        BlockState airBlock = Blocks.AIR.defaultBlockState();
        BlockState redBlock = Blocks.RED_CONCRETE.defaultBlockState();
        BlockPos startPos = new BlockPos(cpos.getMinBlockX(), 55, cpos.getMinBlockZ());
        int x = cpos.x;
        int z = cpos.z;
        ChunkPos west = new ChunkPos(x - 1, z);
        ChunkPos east = new ChunkPos(x + 1, z);
        ChunkPos north = new ChunkPos(x, z - 1);
        ChunkPos south = new ChunkPos(x, z + 1);
        DungeonRoom westRoom = DungeonData.get((Level)world).getRoomAtPos(west);
        DungeonRoom eastRoom = DungeonData.get((Level)world).getRoomAtPos(east);
        DungeonRoom northRoom = DungeonData.get((Level)world).getRoomAtPos(north);
        DungeonRoom southRoom = DungeonData.get((Level)world).getRoomAtPos(south);
        if (westRoom == null) {
            world.setBlock(startPos.south(7).east(0).above(0), fillBlock, 2);
            world.setBlock(startPos.south(7).east(1).above(0), fillBlock, 2);
            world.setBlock(startPos.south(8).east(0).above(0), fillBlock, 2);
            world.setBlock(startPos.south(8).east(1).above(0), fillBlock, 2);
            world.setBlock(startPos.south(7).east(0).above(1), fillBlock, 2);
            world.setBlock(startPos.south(7).east(1).above(1), fillBlock, 2);
            world.setBlock(startPos.south(8).east(0).above(1), fillBlock, 2);
            world.setBlock(startPos.south(8).east(1).above(1), fillBlock, 2);
            world.setBlock(startPos.south(7).east(0).above(2), fillBlock, 2);
            world.setBlock(startPos.south(7).east(1).above(2), fillBlock, 2);
            world.setBlock(startPos.south(8).east(0).above(2), fillBlock, 2);
            world.setBlock(startPos.south(8).east(1).above(2), fillBlock, 2);
            world.setBlock(startPos.south(7).east(0).above(7), airBlock, 2);
            world.setBlock(startPos.south(8).east(0).above(7), airBlock, 2);
        } else if (westRoom.roomType != DungeonDesigner.RoomType.LARGE && westRoom.roomType != DungeonDesigner.RoomType.LARGE_DUMMY) {
            world.setBlock(startPos.south(7).east(1).above(7), redBlock, 2);
            world.setBlock(startPos.south(8).east(1).above(7), redBlock, 2);
            world.setBlock(startPos.south(7).east(2).above(7), redBlock, 2);
            world.setBlock(startPos.south(8).east(2).above(7), redBlock, 2);
            world.setBlock(startPos.south(7).east(3).above(7), redBlock, 2);
            world.setBlock(startPos.south(8).east(3).above(7), redBlock, 2);
            world.setBlock(startPos.south(7).east(4).above(7), redBlock, 2);
            world.setBlock(startPos.south(8).east(4).above(7), redBlock, 2);
            world.setBlock(startPos.south(7).east(5).above(7), redBlock, 2);
            world.setBlock(startPos.south(8).east(5).above(7), redBlock, 2);
            world.setBlock(startPos.south(7).east(6).above(7), redBlock, 2);
            world.setBlock(startPos.south(8).east(6).above(7), redBlock, 2);
        }
        if (eastRoom == null) {
            world.setBlock(startPos.south(7).east(14).above(0), fillBlock, 2);
            world.setBlock(startPos.south(7).east(15).above(0), fillBlock, 2);
            world.setBlock(startPos.south(8).east(14).above(0), fillBlock, 2);
            world.setBlock(startPos.south(8).east(15).above(0), fillBlock, 2);
            world.setBlock(startPos.south(7).east(14).above(1), fillBlock, 2);
            world.setBlock(startPos.south(7).east(15).above(1), fillBlock, 2);
            world.setBlock(startPos.south(8).east(14).above(1), fillBlock, 2);
            world.setBlock(startPos.south(8).east(15).above(1), fillBlock, 2);
            world.setBlock(startPos.south(7).east(14).above(2), fillBlock, 2);
            world.setBlock(startPos.south(7).east(15).above(2), fillBlock, 2);
            world.setBlock(startPos.south(8).east(14).above(2), fillBlock, 2);
            world.setBlock(startPos.south(8).east(15).above(2), fillBlock, 2);
            world.setBlock(startPos.south(7).east(15).above(7), airBlock, 2);
            world.setBlock(startPos.south(8).east(15).above(7), airBlock, 2);
        } else if (eastRoom.roomType != DungeonDesigner.RoomType.LARGE && eastRoom.roomType != DungeonDesigner.RoomType.LARGE_DUMMY) {
            world.setBlock(startPos.south(7).east(14).above(7), redBlock, 2);
            world.setBlock(startPos.south(8).east(14).above(7), redBlock, 2);
            world.setBlock(startPos.south(7).east(13).above(7), redBlock, 2);
            world.setBlock(startPos.south(8).east(13).above(7), redBlock, 2);
            world.setBlock(startPos.south(7).east(12).above(7), redBlock, 2);
            world.setBlock(startPos.south(8).east(12).above(7), redBlock, 2);
            world.setBlock(startPos.south(7).east(11).above(7), redBlock, 2);
            world.setBlock(startPos.south(8).east(11).above(7), redBlock, 2);
            world.setBlock(startPos.south(7).east(10).above(7), redBlock, 2);
            world.setBlock(startPos.south(8).east(10).above(7), redBlock, 2);
            world.setBlock(startPos.south(7).east(9).above(7), redBlock, 2);
            world.setBlock(startPos.south(8).east(9).above(7), redBlock, 2);
        }
        if (northRoom != null && northRoom.roomType != DungeonDesigner.RoomType.LARGE && northRoom.roomType != DungeonDesigner.RoomType.LARGE_DUMMY) {
            world.setBlock(startPos.south(1).east(7).above(7), redBlock, 2);
            world.setBlock(startPos.south(1).east(8).above(7), redBlock, 2);
            world.setBlock(startPos.south(2).east(7).above(7), redBlock, 2);
            world.setBlock(startPos.south(2).east(8).above(7), redBlock, 2);
            world.setBlock(startPos.south(3).east(7).above(7), redBlock, 2);
            world.setBlock(startPos.south(3).east(8).above(7), redBlock, 2);
            world.setBlock(startPos.south(4).east(7).above(7), redBlock, 2);
            world.setBlock(startPos.south(4).east(8).above(7), redBlock, 2);
            world.setBlock(startPos.south(5).east(7).above(7), redBlock, 2);
            world.setBlock(startPos.south(5).east(8).above(7), redBlock, 2);
            world.setBlock(startPos.south(6).east(7).above(7), redBlock, 2);
            world.setBlock(startPos.south(6).east(8).above(7), redBlock, 2);
        }
        if (southRoom != null && southRoom.roomType != DungeonDesigner.RoomType.LARGE && southRoom.roomType != DungeonDesigner.RoomType.LARGE_DUMMY) {
            world.setBlock(startPos.south(14).east(7).above(7), redBlock, 2);
            world.setBlock(startPos.south(14).east(8).above(7), redBlock, 2);
            world.setBlock(startPos.south(13).east(7).above(7), redBlock, 2);
            world.setBlock(startPos.south(13).east(8).above(7), redBlock, 2);
            world.setBlock(startPos.south(12).east(7).above(7), redBlock, 2);
            world.setBlock(startPos.south(12).east(8).above(7), redBlock, 2);
            world.setBlock(startPos.south(11).east(7).above(7), redBlock, 2);
            world.setBlock(startPos.south(11).east(8).above(7), redBlock, 2);
            world.setBlock(startPos.south(10).east(7).above(7), redBlock, 2);
            world.setBlock(startPos.south(10).east(8).above(7), redBlock, 2);
            world.setBlock(startPos.south(9).east(7).above(7), redBlock, 2);
            world.setBlock(startPos.south(9).east(8).above(7), redBlock, 2);
        }
    }

    public static boolean putRoomHere(ChunkPos cpos, ServerLevel world, DungeonRoom room) {
        MinecraftServer minecraftserver = world.getServer();
        StructureTemplateManager templatemanager = DungeonUtils.getDungeonWorld(minecraftserver).getStructureManager();
        StructureTemplate template = templatemanager.getOrCreate(ResourceLocation.parse((String)room.structure));
        StructurePlaceSettings placementsettings = new StructurePlaceSettings().setMirror(Mirror.NONE).setRotation(Rotation.NONE).setIgnoreEntities(false);
        placementsettings.setBoundingBox(placementsettings.getBoundingBox());
        placementsettings.setRotation(room.rotation);
        BlockPos position = new BlockPos(cpos.getMinBlockX(), 50, cpos.getMinBlockZ());
        BlockPos sizeRange = new BlockPos(16, 13, 16);
        if (template == null) {
            DimDungeons.logMessageInfo("DIMDUNGEONS FATAL ERROR: Structure does not exist (" + room.structure + ")");
            return false;
        }
        if (room.rotation == Rotation.COUNTERCLOCKWISE_90) {
            placementsettings.setRotation(Rotation.COUNTERCLOCKWISE_90);
            position = position.offset(0, 0, template.getSize().getZ() - 1);
        } else if (room.rotation == Rotation.CLOCKWISE_90) {
            placementsettings.setRotation(Rotation.CLOCKWISE_90);
            position = position.offset(template.getSize().getX() - 1, 0, 0);
        } else if (room.rotation == Rotation.CLOCKWISE_180) {
            placementsettings.setRotation(Rotation.CLOCKWISE_180);
            position = position.offset(template.getSize().getX() - 1, 0, template.getSize().getZ() - 1);
        } else {
            placementsettings.setRotation(Rotation.NONE);
        }
        boolean success = template.placeInWorld((ServerLevelAccessor)world, position, sizeRange, placementsettings, world.getRandom(), 2);
        for (StructureTemplate.StructureBlockInfo template$blockinfo : template.filterBlocks(position, placementsettings, Blocks.STRUCTURE_BLOCK)) {
            StructureMode structuremode;
            if (template$blockinfo.nbt() == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.nbt().getString("mode"))) != StructureMode.DATA) continue;
            DungeonPlacement.handleDataBlock(template$blockinfo.nbt().getString("metadata"), template$blockinfo.pos(), world, world.getRandom(), placementsettings.getBoundingBox(), room);
        }
        if (room.dungeonType == DungeonDesigner.DungeonType.ADVANCED) {
            for (StructureTemplate.StructureBlockInfo info : template.filterBlocks(position, placementsettings, Blocks.RED_CARPET)) {
                world.setBlock(info.pos(), Blocks.GREEN_CARPET.defaultBlockState(), 3);
            }
        }
        return success;
    }

    public void printMap(DungeonDesigner dbl) {
        for (int j = 0; j < 8; ++j) {
            Object dungeonRowShape = "";
            for (int i = 0; i < 8; ++i) {
                dungeonRowShape = (String)dungeonRowShape + (dbl.finalLayout[i][j].hasRoom() ? "*" : ".");
            }
            System.out.println((String)dungeonRowShape);
        }
    }

    protected static void handleDataBlock(String name, BlockPos pos, ServerLevel world, RandomSource rand, BoundingBox bb, DungeonRoom room) {
        if ("ReturnPortal".equals(name)) {
            world.setBlock(pos, ((BlockGoldPortal)((Object)BlockRegistrar.BLOCK_GOLD_PORTAL.get())).defaultBlockState(), 2);
            TileEntityGoldPortal te = (TileEntityGoldPortal)world.getBlockEntity(pos);
            if (te != null) {
                te.setDestination(0.0, -10000.0, 0.0, "minecraft:overworld", Direction.NORTH);
            }
        } else if ("BackToEntrance".equals(name)) {
            world.setBlock(pos, ((BlockLocalTeleporter)((Object)BlockRegistrar.BLOCK_LOCAL_TELEPORTER.get())).defaultBlockState(), 2);
            TileEntityLocalTeleporter te = (TileEntityLocalTeleporter)world.getBlockEntity(pos);
            if (te != null) {
                double topLeftX = Math.floor(pos.getX() / 256);
                double entranceX = topLeftX * 256.0 + 136.0;
                double topLeftZ = Math.floor(pos.getZ() / 256);
                double entranceZ = topLeftZ * 256.0 + 188.5;
                te.setDestination(entranceX, 55.1, entranceZ, 0.0, 180.0);
            }
        } else if ("LockItStoneBrick".equals(name)) {
            world.setBlock(pos, Blocks.STONE_BRICKS.defaultBlockState(), 2);
        } else if (!"LockIt".equals(name)) {
            if ("LockWithCode".equals(name)) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                BlockEntity te = world.getBlockEntity(pos.below());
                if (te instanceof BaseContainerBlockEntity) {
                    CompoundTag tag = ((BaseContainerBlockEntity)te).getUpdateTag((HolderLookup.Provider)world.getLevel().registryAccess());
                    String lockName = "Chest Key: " + DungeonPlacement.makeChunkCode(world.getChunk(pos).getPos());
                    tag.putString("Lock", lockName);
                    te.handleUpdateTag(tag, (HolderLookup.Provider)world.getLevel().registryAccess());
                    String lootType = room.dungeonType == DungeonDesigner.DungeonType.BASIC ? "basic" : "advanced";
                    String lootTable = "chest/chestloot_" + lootType + "_hard";
                    DungeonPlacement.fillChestBelow(pos, ResourceLocation.fromNamespaceAndPath((String)"dimdungeons", (String)lootTable), (LevelAccessor)world, rand);
                }
            } else if ("FortuneTeller".equals(name)) {
                world.setBlock(pos, Blocks.STONE_BRICKS.defaultBlockState(), 2);
                BlockEntity te = world.getBlockEntity(pos.below());
                if (te instanceof DispenserBlockEntity) {
                    ((DispenserBlockEntity)te).clearContent();
                    ItemStack message = DungeonPlacement.generateLuckyMessage(rand, room.dungeonType);
                    ((DispenserBlockEntity)te).insertItem(message);
                }
            } else if ("ChestLoot1".equals(name) || "SetTrappedLoot".equals(name) || "BarrelLoot1".equals(name)) {
                String lootType = room.dungeonType == DungeonDesigner.DungeonType.BASIC ? "basic" : "advanced";
                String lootTable = "chest/chestloot_" + lootType + "_easy";
                DungeonPlacement.fillChestBelow(pos, ResourceLocation.fromNamespaceAndPath((String)"dimdungeons", (String)lootTable), (LevelAccessor)world, rand);
            } else if ("ChestLoot2".equals(name)) {
                String lootType = room.dungeonType == DungeonDesigner.DungeonType.BASIC ? "basic" : "advanced";
                String lootTable = "chest/chestloot_" + lootType + "_hard";
                DungeonPlacement.fillChestBelow(pos, ResourceLocation.fromNamespaceAndPath((String)"dimdungeons", (String)lootTable), (LevelAccessor)world, rand);
            } else if ("ChestLootKit".equals(name)) {
                String lootTable = "chest/kit_random";
                DungeonPlacement.fillChestBelow(pos, ResourceLocation.fromNamespaceAndPath((String)"dimdungeons", (String)lootTable), (LevelAccessor)world, rand);
            } else if ("ChestLootLucky".equals(name)) {
                int lucky = rand.nextInt(100);
                if (lucky < 30) {
                    if (room.dungeonType == DungeonDesigner.DungeonType.BASIC) {
                        DungeonPlacement.fillChestBelow(pos, ResourceLocation.fromNamespaceAndPath((String)"dimdungeons", (String)"chest/chestloot_lucky"), (LevelAccessor)world, rand);
                    } else {
                        DungeonPlacement.fillChestBelow(pos, ResourceLocation.fromNamespaceAndPath((String)"dimdungeons", (String)"chest/chestloot_crazy"), (LevelAccessor)world, rand);
                    }
                } else {
                    if (DungeonConfig.isModInstalled("artifacts") && lucky < 40) {
                        DungeonPlacement.spawnEnemyHere(pos, "artifacts:mimic", world, room.theme, room.dungeonType);
                    }
                    world.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                    world.setBlock(pos.below(), Blocks.AIR.defaultBlockState(), 2);
                }
            } else if ("PlaceL2Key".equals(name)) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                TileEntityPortalKeyhole te = (TileEntityPortalKeyhole)world.getBlockEntity(pos.below());
                if (te != null) {
                    te.removeContents();
                    te.setContents(new ItemStack((ItemLike)ItemRegistrar.ITEM_BLANK_ADVANCED_KEY.get()));
                }
            } else if (name.contains("TeleporterKey_")) {
                String tempDoornum = name.replace("TeleporterKey_", "");
                int doornum = Integer.valueOf(tempDoornum);
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                TileEntityPortalKeyhole te = (TileEntityPortalKeyhole)world.getBlockEntity(pos.below(3));
                if (te != null) {
                    ItemStack newkey = new ItemStack((ItemLike)ItemRegistrar.ITEM_PORTAL_KEY.get());
                    int topLeftX = bb.minX() - 48;
                    int destX = topLeftX / 256;
                    int topLeftZ = bb.minZ() - 48;
                    int destZ = topLeftZ / 256;
                    ItemPortalKey.activateKeyForExistingTeleporterHub(world.getServer(), newkey, destX, destZ, doornum);
                    BlockState state = world.getBlockState(pos.below(3));
                    BlockState newBlockState = (BlockState)((BlockState)((BlockState)state.setValue((Property)BlockPortalKeyhole.FACING, (Comparable)((Direction)state.getValue((Property)BlockPortalKeyhole.FACING)))).setValue((Property)BlockPortalKeyhole.FILLED, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockPortalKeyhole.LIT, (Comparable)Boolean.valueOf(false));
                    world.setBlockAndUpdate(pos.below(3), newBlockState);
                    te.setContents(newkey);
                }
            } else if ("SummonWitch".equals(name)) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                DungeonPlacement.spawnEnemyHere(pos, "minecraft:witch", world, room.theme, room.dungeonType);
            } else if ("SummonWaterEnemy".equals(name)) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                DungeonPlacement.spawnEnemyHere(pos, "minecraft:guardian", world, room.theme, room.dungeonType);
            } else if ("SummonEnderman".equals(name)) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                DungeonPlacement.spawnEnemyHere(pos, "minecraft:enderman", world, room.theme, room.dungeonType);
            } else if ("SummonEnemy1".equals(name)) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                int poolSize = DungeonConfig.basicEnemySet1.size();
                String mobid = DungeonConfig.basicEnemySet1.get(rand.nextInt(poolSize));
                if (room.theme > 0) {
                    poolSize = DungeonConfig.themeSettings.get((int)(room.theme - 1)).themeEnemySet1.size();
                    mobid = DungeonConfig.themeSettings.get((int)(room.theme - 1)).themeEnemySet1.get(rand.nextInt(poolSize));
                }
                if (room.dungeonType == DungeonDesigner.DungeonType.ADVANCED) {
                    poolSize = DungeonConfig.advancedEnemySet1.size();
                    mobid = DungeonConfig.advancedEnemySet1.get(rand.nextInt(poolSize));
                }
                DungeonPlacement.spawnEnemyHere(pos, mobid, world, room.theme, room.dungeonType);
            } else if ("SummonEnemy2".equals(name) || "SummonKeyholder".equals(name)) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                int poolSize = DungeonConfig.basicEnemySet2.size();
                String mobid = DungeonConfig.basicEnemySet2.get(rand.nextInt(poolSize));
                if (room.theme > 0) {
                    poolSize = DungeonConfig.themeSettings.get((int)(room.theme - 1)).themeEnemySet2.size();
                    mobid = DungeonConfig.themeSettings.get((int)(room.theme - 1)).themeEnemySet2.get(rand.nextInt(poolSize));
                }
                if (room.dungeonType == DungeonDesigner.DungeonType.ADVANCED) {
                    poolSize = DungeonConfig.advancedEnemySet2.size();
                    mobid = DungeonConfig.advancedEnemySet2.get(rand.nextInt(poolSize));
                }
                Entity mob = DungeonPlacement.spawnEnemyHere(pos, mobid, world, room.theme, room.dungeonType);
                if ("SummonKeyholder".equals(name) && !((Mob)mob).hasItemInSlot(EquipmentSlot.CHEST)) {
                    ItemStack stack = new ItemStack((ItemLike)Items.STICK);
                    String lockName = "Chest Key: " + DungeonPlacement.makeChunkCode(world.getChunk(pos).getPos());
                    stack.update(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)lockName), component -> component);
                    ((Mob)mob).setItemSlot(EquipmentSlot.CHEST, stack);
                    ((Mob)mob).setDropChance(EquipmentSlot.CHEST, 1.0f);
                }
                AttributeInstance tempHealth = ((Mob)mob).getAttribute(Attributes.MAX_HEALTH);
                ((Mob)mob).getAttribute(Attributes.MAX_HEALTH).setBaseValue(tempHealth.getBaseValue() * 1.5);
                ((Mob)mob).setHealth((float)((Mob)mob).getAttribute(Attributes.MAX_HEALTH).getBaseValue());
                ((Mob)mob).addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 9999999, 1, false, false));
                ((Mob)mob).addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 9999999, 1, false, false));
            } else {
                DimDungeons.logMessageWarn("UNHANDLED DATA BLOCK WITH name = " + name);
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
            }
        }
    }

    private static Entity spawnEnemyHere(BlockPos pos, String resourceLocation, ServerLevel world, int theme, DungeonDesigner.DungeonType type) {
        EntityType entitytype = EntityType.byString((String)resourceLocation).orElse(EntityType.CHICKEN);
        Entity mob = entitytype.spawn(world, null, null, pos, MobSpawnType.STRUCTURE, true, true);
        if (mob == null) {
            return null;
        }
        mob.moveTo(pos, 0.0f, 0.0f);
        String advancedDungeonNames = type == DungeonDesigner.DungeonType.ADVANCED ? "2" : "";
        MutableComponent fancyName = Component.translatable((String)("enemy.dimdungeons." + resourceLocation + advancedDungeonNames));
        if (fancyName != null && !fancyName.getString().contains("enemy.dimdungeons.")) {
            mob.setCustomName((Component)fancyName);
        }
        if (mob instanceof Mob) {
            ((Mob)mob).setCanPickUpLoot(false);
            ((Mob)mob).restrictTo(pos, 8);
            ((Mob)mob).setPersistenceRequired();
            double healthScaling = DungeonConfig.basicEnemyHealthScaling;
            if (theme > 0) {
                healthScaling = DungeonConfig.themeSettings.get((int)(theme - 1)).themeEnemyHealthScaling;
            }
            if (type == DungeonDesigner.DungeonType.ADVANCED) {
                healthScaling = DungeonConfig.advancedEnemyHealthScaling;
            }
            AttributeInstance tempHealth = ((Mob)mob).getAttribute(Attributes.MAX_HEALTH);
            ((Mob)mob).getAttribute(Attributes.MAX_HEALTH).setBaseValue(tempHealth.getBaseValue() * healthScaling);
            ((Mob)mob).setHealth((float)((Mob)mob).getAttribute(Attributes.MAX_HEALTH).getBaseValue());
            int chanceForTheme = DungeonConfig.chanceForThemeKeys;
            if (type == DungeonDesigner.DungeonType.ADVANCED) {
                chanceForTheme /= 2;
            }
            if (world.getRandom().nextInt(100) < chanceForTheme && DungeonConfig.themeSettings.size() > 0 && theme < 1 && !((Mob)mob).hasItemInSlot(EquipmentSlot.OFFHAND)) {
                int numThemes = DungeonConfig.themeSettings.size();
                ItemStack stack = new ItemStack((ItemLike)ItemRegistrar.ITEM_PORTAL_KEY.get());
                ((ItemPortalKey)((Object)ItemRegistrar.ITEM_PORTAL_KEY.get())).activateKeyLevel1(world.getServer(), stack, world.getRandom().nextInt(numThemes) + 1);
                ((Mob)mob).setItemInHand(InteractionHand.OFF_HAND, stack);
                ((Mob)mob).setDropChance(EquipmentSlot.OFFHAND, 1.0f);
            }
            if (type == DungeonDesigner.DungeonType.ADVANCED) {
                ((Mob)mob).getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((double)0.35f);
                ((Mob)mob).addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 9999999, 1, false, false));
                ((Mob)mob).addEffect(new MobEffectInstance(MobEffects.JUMP, 9999999, 3, false, false));
                ((Mob)mob).addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 9999999, 1, false, false));
            }
        }
        return mob;
    }

    private static void fillChestBelow(BlockPos pos, ResourceLocation lootTable, LevelAccessor world, RandomSource rand) {
        world.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
        ResourceKey lootTableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable);
        RandomizableContainer.setBlockEntityLootTable((BlockGetter)world, (RandomSource)rand, (BlockPos)pos.below(), (ResourceKey)lootTableKey);
    }

    private static ItemStack generateLuckyMessage(RandomSource rand, DungeonDesigner.DungeonType type) {
        int bookType = rand.nextInt(3);
        if (type == DungeonDesigner.DungeonType.ADVANCED) {
            bookType = 3;
        }
        int messageVariation = rand.nextInt(8) + 1;
        MutableComponent title = Component.translatable((String)"book.dimdungeons.title_1");
        MutableComponent body = Component.translatable((String)"book.dimdungeons.author");
        MutableComponent author = Component.translatable((String)"book.dimdungeons.author");
        if (bookType == 0) {
            title = Component.translatable((String)"book.dimdungeons.title_1");
            body = Component.translatable((String)("book.dimdungeons.fun_message_" + messageVariation));
        } else if (bookType == 1) {
            title = Component.translatable((String)"book.dimdungeons.title_2");
            body = Component.translatable((String)("book.dimdungeons.helpful_message_" + messageVariation));
        } else if (bookType == 2) {
            title = Component.translatable((String)"book.dimdungeons.title_3");
            body = Component.translatable((String)("book.dimdungeons.dangerous_message_" + messageVariation));
        } else if (bookType == 3) {
            title = Component.translatable((String)"book.dimdungeons.title_4");
            body = Component.translatable((String)("book.dimdungeons.advanced_message_" + messageVariation));
        }
        Filterable titleFilter = new Filterable((Object)title.getString(), Optional.of(title.getString()));
        ArrayList<Filterable> pages = new ArrayList<Filterable>();
        MutableComponent text = Component.translatable((String)body.getString());
        Filterable pageText = new Filterable((Object)text, Optional.of(text));
        pages.addFirst(pageText);
        WrittenBookContent bookComponent = new WrittenBookContent(titleFilter, author.getString(), 0, pages, true);
        ItemStack stack = new ItemStack((ItemLike)Items.WRITTEN_BOOK);
        stack.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)bookComponent);
        return stack;
    }

    public static String makeChunkCode(ChunkPos pos) {
        int r = pos.x * 2 + pos.z;
        r ^= r << 13;
        r ^= r >> 17;
        r ^= r << 5;
        String code = String.format("%04d", r %= 9999);
        return code;
    }
}

