/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism;

import com.google.common.collect.AbstractIterator;
import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public class ChemicalCapabilityCache {
    private final BlockCapabilityCache<IChemicalHandler, @NullableType Direction> cache;

    public ChemicalCapabilityCache(ServerLevel level, BlockPos pos, Direction direction) {
        this.cache = BlockCapabilityCache.create(ChemicalUtil.BLOCK_CAPABILITY, (ServerLevel)level, (BlockPos)pos, (Object)direction);
    }

    public Optional<IChemicalHandler> getCapability() {
        return Optional.ofNullable((IChemicalHandler)this.cache.getCapability());
    }

    public Iterator<ResourceAmount> createAmountIterator() {
        return this.getCapability().map(handler -> new AbstractIterator<ResourceAmount>(this){
            private int index;

            @Nullable
            protected ResourceAmount computeNext() {
                if (this.index > handler.getChemicalTanks()) {
                    return (ResourceAmount)this.endOfData();
                }
                while (this.index < handler.getChemicalTanks()) {
                    ChemicalStack slot = handler.getChemicalInTank(this.index);
                    if (!slot.isEmpty()) {
                        ++this.index;
                        return new ResourceAmount((ResourceKey)ChemicalResource.ofChemicalStack(slot), slot.getAmount());
                    }
                    ++this.index;
                }
                return (ResourceAmount)this.endOfData();
            }
        }).orElse(Collections.emptyListIterator());
    }

    public Iterator<ResourceKey> createIterator() {
        return this.getCapability().map(handler -> new AbstractIterator<ResourceKey>(this){
            private int index;

            @Nullable
            protected ResourceKey computeNext() {
                if (this.index > handler.getChemicalTanks()) {
                    return (ResourceKey)this.endOfData();
                }
                while (this.index < handler.getChemicalTanks()) {
                    ChemicalStack slot = handler.getChemicalInTank(this.index);
                    if (!slot.isEmpty()) {
                        ++this.index;
                        return ChemicalResource.ofChemicalStack(slot);
                    }
                    ++this.index;
                }
                return (ResourceKey)this.endOfData();
            }
        }).orElse(Collections.emptyListIterator());
    }
}

