/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism.storage;

import com.refinedmods.refinedstorage.common.api.storage.AbstractStorageContainerItem;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItemHelper;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.common.storage.UpgradeableStorageContainer;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceRendering;
import com.refinedmods.refinedstorage.mekanism.MekanismIntegrationIdentifierUtil;
import com.refinedmods.refinedstorage.mekanism.content.Items;
import com.refinedmods.refinedstorage.mekanism.storage.ChemicalStorageBlockBlockItem;
import com.refinedmods.refinedstorage.mekanism.storage.ChemicalStorageVariant;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ChemicalStorageDiskItem
extends AbstractStorageContainerItem
implements UpgradeableStorageContainer {
    private static final Component CREATIVE_HELP = MekanismIntegrationIdentifierUtil.createMekanismIntegrationTranslation("item", "creative_chemical_storage_disk.help");
    private final ChemicalStorageVariant variant;
    private final Component helpText;

    public ChemicalStorageDiskItem(StorageContainerItemHelper helper, ChemicalStorageVariant variant) {
        super(new Item.Properties().stacksTo(1).fireResistant(), helper);
        this.variant = variant;
        this.helpText = ChemicalStorageDiskItem.getHelpText(variant);
    }

    private static Component getHelpText(ChemicalStorageVariant variant) {
        if (variant.getCapacityInBuckets() == null) {
            return CREATIVE_HELP;
        }
        return MekanismIntegrationIdentifierUtil.createMekanismIntegrationTranslation("item", "chemical_storage_disk.help", IdentifierUtil.format((long)variant.getCapacityInBuckets()));
    }

    @Nullable
    protected Long getCapacity() {
        return this.variant.getCapacity();
    }

    protected String formatAmount(long amount) {
        return ChemicalResourceRendering.format(amount);
    }

    protected SerializableStorage createStorage(StorageRepository storageRepository) {
        return ChemicalStorageBlockBlockItem.createStorage(this.variant, () -> ((StorageRepository)storageRepository).markAsChanged());
    }

    protected ItemStack createPrimaryDisassemblyByproduct(int count) {
        return new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getStorageHousing(), count);
    }

    @Nullable
    protected ItemStack createSecondaryDisassemblyByproduct(int count) {
        if (this.variant == ChemicalStorageVariant.CREATIVE) {
            return null;
        }
        return new ItemStack((ItemLike)Items.getChemicalStoragePart(this.variant), count);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new HelpTooltipComponent(this.helpText));
    }

    public StorageVariant getVariant() {
        return this.variant;
    }

    public void transferTo(ItemStack from, ItemStack to) {
        this.helper.markAsToTransfer(from, to);
    }
}

