/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism.storagemonitor;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.api.storagemonitor.StorageMonitorInsertionStrategy;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.world.item.ItemStack;

public class ChemicalStorageMonitorInsertionStrategy
implements StorageMonitorInsertionStrategy {
    public Optional<ItemStack> insert(ResourceKey configuredResource, ItemStack stack, Actor actor, Network network) {
        if (!(configuredResource instanceof ChemicalResource)) {
            return Optional.empty();
        }
        ChemicalResource configuredChemicalResource = (ChemicalResource)configuredResource;
        RootStorage rootStorage = (RootStorage)network.getComponent(StorageNetworkComponent.class);
        ItemStack modifiedStack = stack.copy();
        return Optional.ofNullable((IChemicalHandler)modifiedStack.getCapability(ChemicalUtil.ITEM_CAPABILITY)).map(handler -> this.handleInsert(actor, configuredChemicalResource, (IChemicalHandler)handler, rootStorage, modifiedStack));
    }

    @Nullable
    private ItemStack handleInsert(Actor actor, ChemicalResource configuredChemicalResource, IChemicalHandler handler, RootStorage rootStorage, ItemStack modifiedStack) {
        ChemicalStack extractedSimulated = handler.extractChemical(Long.MAX_VALUE, mekanism.api.Action.SIMULATE);
        if (extractedSimulated.isEmpty()) {
            return null;
        }
        long insertedSimulated = this.tryInsert(actor, configuredChemicalResource, extractedSimulated, rootStorage);
        if (insertedSimulated == 0L) {
            return null;
        }
        ChemicalStack extracted = handler.extractChemical(insertedSimulated, mekanism.api.Action.EXECUTE);
        if (extracted.isEmpty()) {
            return null;
        }
        this.doInsert(actor, extracted, rootStorage);
        return modifiedStack;
    }

    private long tryInsert(Actor actor, ChemicalResource configuredResource, ChemicalStack result, RootStorage rootStorage) {
        if (!result.getChemical().equals(configuredResource.chemical())) {
            return 0L;
        }
        return rootStorage.insert((ResourceKey)ChemicalResource.ofChemicalStack(result), result.getAmount(), Action.SIMULATE, actor);
    }

    private void doInsert(Actor actor, ChemicalStack result, RootStorage rootStorage) {
        rootStorage.insert((ResourceKey)ChemicalResource.ofChemicalStack(result), result.getAmount(), Action.EXECUTE, actor);
    }
}

