/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.beer.mixin;

import com.breakinblocks.beer.util.BookshelfOffsetUtil;
import dev.shadowsoffire.apothic_enchanting.table.EnchantmentTableStats;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EnchantingTableBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;

@Pseudo
@Mixin(value={EnchantmentTableStats.class})
public abstract class TableStatsMixin {
    @Shadow
    public static boolean canReadStatsFrom(LevelReader level, BlockPos pos, BlockPos offset) {
        throw new AssertionError();
    }

    @Shadow
    public static void gatherStats(EnchantmentTableStats.Builder builder, LevelReader level, BlockPos pos) {
        throw new AssertionError();
    }

    @Overwrite
    public static EnchantmentTableStats gatherStats(LevelReader level, BlockPos pos, int itemEnch) {
        EnchantmentTableStats.Builder builder = new EnchantmentTableStats.Builder(itemEnch);
        if (level instanceof Level) {
            Level worldLevel = (Level)level;
            for (BlockPos offset : BookshelfOffsetUtil.getOffsetsForTable(worldLevel, pos)) {
                if (!TableStatsMixin.canReadStatsFrom(level, pos, offset)) continue;
                TableStatsMixin.gatherStats(builder, level, pos.offset((Vec3i)offset));
            }
        } else {
            for (BlockPos offset : EnchantingTableBlock.BOOKSHELF_OFFSETS) {
                if (!TableStatsMixin.canReadStatsFrom(level, pos, offset)) continue;
                TableStatsMixin.gatherStats(builder, level, pos.offset((Vec3i)offset));
            }
        }
        return builder.build();
    }
}

