/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.common.entity.SunderingAnchorProjectileEntity;
import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.strawberry.gaze.GazeMod;
import com.strawberry.gaze.common.entity.SaberProjectileEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class SaberEntityRenderer
extends EntityRenderer<SaberProjectileEntity> {
    public final ItemRenderer itemRenderer;

    public SaberEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public ResourceLocation getTextureLocation(SaberProjectileEntity SaberProjectileEntity2) {
        return GazeMod.gazePath("saber_projectile");
    }

    public boolean shouldRender(SaberProjectileEntity livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public void render(SaberProjectileEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) + 90.0f));
        float rotation = -(((float)entity.tickCount + partialTicks) * 40.0f);
        poseStack.mulPose(Axis.ZN.rotationDegrees(rotation));
        poseStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
        ItemStack itemstack = entity.getItem();
        BakedModel model = this.itemRenderer.getModel(itemstack, entity.level(), (LivingEntity)null, 1);
        this.itemRenderer.render(itemstack, itemstack.getItem() instanceof MalumScytheItem ? ItemDisplayContext.NONE : ItemDisplayContext.FIXED, false, poseStack, bufferIn, packedLightIn, OverlayTexture.NO_OVERLAY, model);
        poseStack.popPose();
        float delta = entity.getVisualEffectScalar();
        float scale = delta * 0.7f;
        float alpha = Mth.clamp((float)(delta * 0.4f), (float)0.0f, (float)1.0f);
        LodestoneRenderTypeBuilder additive = LodestoneRenderTypes.ADDITIVE_TWO_SIDED_TEXTURE_TRIANGLE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL);
        LodestoneRenderTypeBuilder transparent = LodestoneRenderTypes.TRANSPARENT_TWO_SIDED_TEXTURE_TRIANGLE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL).withUniformHandler(ShaderUniformHandler.LUMITRANSPARENT);
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setRenderType(additive);
        builder.setRenderType(transparent);
        RenderUtils.renderEntityTrail((PoseStack)poseStack, (VFXBuilders.WorldVFXBuilder)builder, (TrailPointBuilder)entity.trailPointBuilder, (Entity)entity, (SpiritLike)MalumSpiritTypes.ELDRITCH_SPIRIT, (float)(scale * 0.6f), (float)(alpha * 0.3f), (float)partialTicks);
        RenderUtils.renderEntityTrail((PoseStack)poseStack, (VFXBuilders.WorldVFXBuilder)builder, (TrailPointBuilder)entity.spinningTrailPointBuilder, (Entity)entity, (SpiritLike)MalumSpiritTypes.ELDRITCH_SPIRIT, (float)scale, (float)alpha, (float)partialTicks);
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(SunderingAnchorProjectileEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

