/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.block.curiosities.fusion_altar;

import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.MalumSpiritBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.spirit_altar.AltarCraftingHelper;
import com.sammy.malum.common.block.curiosities.spirit_altar.AltarSoundInstance;
import com.sammy.malum.common.block.curiosities.spirit_altar.IAltarAccelerator;
import com.sammy.malum.common.block.curiosities.spirit_altar.SpiritAltarBlockEntity;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.block.MalumBlocks;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.strawberry.gaze.registry.common.block.GazeBlockEntities;
import com.strawberry.gaze.visual_effects.FusionAltarParticleEffects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import team.lodestar.lodestone.helpers.NBTHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.helpers.block.BlockEntityHelper;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataBuilder;

public class FusionAltarBlockEntity
extends SpiritAltarBlockEntity {
    public static final Vec3 ALTAR_ITEM_OFFSET = new Vec3(0.5, 1.25, 0.5);
    public static final int HORIZONTAL_RANGE = 4;
    public static final int VERTICAL_RANGE = 3;
    private static final int WARMUP_DURATION = 30;
    public static final int CRAFT_TIME = 200;
    public float speed = 1.0f;
    public int progress;
    public int idleProgress;
    public float warmupTimer;
    public float spiritAmount;
    public float spiritSpin;
    public boolean isCrafting;
    public int spiritCost = 0;
    public List<BlockPos> acceleratorPositions = new ArrayList<BlockPos>();
    public List<IAltarAccelerator> accelerators = new ArrayList<IAltarAccelerator>();
    public static final Item[] SPIRIT_TYPES = new Item[]{(Item)MalumItems.SACRED_SPIRIT.get(), (Item)MalumItems.ELDRITCH_SPIRIT.get(), (Item)MalumItems.EARTHEN_SPIRIT.get(), (Item)MalumItems.INFERNAL_SPIRIT.get(), (Item)MalumItems.AQUEOUS_SPIRIT.get(), (Item)MalumItems.AERIAL_SPIRIT.get(), (Item)MalumItems.ARCANE_SPIRIT.get(), (Item)MalumItems.WICKED_SPIRIT.get()};

    public FusionAltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)GazeBlockEntities.FUSION_ALTAR.get(), pos, state);
        this.inventory = MalumBlockEntityInventory.singleStackNotSpirit((LodestoneBlockEntity)this).onContentsChanged(this::recalculateCost);
        this.extrasInventory = MalumBlockEntityInventory.stacksNotSpirits((LodestoneBlockEntity)this, (int)8);
        this.spiritInventory = MalumSpiritBlockEntityInventory.spiritStacks((LodestoneBlockEntity)this).onContentsChanged(this::recalculateCost);
    }

    private void recalculateCost() {
        this.inventory.updateInventoryCaches();
        HashMap merged = new HashMap();
        this.spiritCost = 0;
        List<ItemStack> items = this.collectEnchantedItems();
        for (ItemStack stack : items) {
            ItemEnchantments enchants = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            enchants.entrySet().forEach(e -> merged.merge((Holder)e.getKey(), e.getIntValue(), Math::max));
            this.spiritCost += ((Integer)stack.getOrDefault(DataComponents.REPAIR_COST, (Object)0)).intValue();
        }
        this.spiritCost = Mth.clamp((int)(this.spiritCost == 0 ? 1 : this.spiritCost), (int)8, (int)64);
    }

    public void tick() {
        if (this.spiritInventory == null) {
            return;
        }
        this.spiritAmount = Math.max(1.0f, Mth.lerp((float)0.1f, (float)this.spiritAmount, (float)this.spiritInventory.getFilledSlotCount()));
        ItemStack primeItem = this.inventory.getStackInSlot(0);
        if (!primeItem.isEmpty()) {
            ++this.idleProgress;
            int progressCap = (int)(20.0f / this.speed);
            if (this.idleProgress >= progressCap) {
                this.recalculateCost();
                this.idleProgress = 0;
                if (this.level != null) {
                    BlockStateHelper.updateAndNotifyState((Level)this.level, (BlockPos)this.worldPosition);
                }
            }
        }
        if (primeItem.isEmpty() || !primeItem.is(Items.BOOK) || !this.hasAllSpirits(this.spiritCost) || this.collectEnchantedItems().isEmpty()) {
            if (this.isCrafting) {
                this.isCrafting = false;
                if (this.level != null) {
                    BlockStateHelper.updateAndNotifyState((Level)this.level, (BlockPos)this.worldPosition);
                }
            }
            this.progress = 0;
            this.warmupTimer = Mth.clamp((float)(this.warmupTimer - 1.0f), (float)0.0f, (float)30.0f);
        } else {
            this.warmupTimer = Math.min(this.warmupTimer + 1.0f, 30.0f);
            if (!this.isCrafting) {
                this.isCrafting = true;
                if (this.level != null) {
                    BlockStateHelper.updateAndNotifyState((Level)this.level, (BlockPos)this.worldPosition);
                }
            }
            if (this.level != null && !this.level.isClientSide && this.level.getGameTime() % 20L == 0L) {
                this.recalibrateAccelerators();
            }
            this.progress += (int)this.speed;
            if (this.progress >= 200) {
                Level level = this.level;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    List<ItemStack> enchantedItems = this.collectEnchantedItems();
                    if (!this.validatePedestalItems(enchantedItems)) {
                        this.resetCrafting();
                        return;
                    }
                    this.doExtraction(serverLevel, primeItem, enchantedItems);
                }
                this.resetCrafting();
            }
        }
        if (this.level != null && this.level.isClientSide && this.spiritInventory != null) {
            this.spiritSpin += 1.0f + this.getSpinUp(Easing.SINE_IN_OUT) * 0.05f + this.speed * 0.5f;
            FusionAltarParticleEffects.passiveFusionAltarParticles(this);
        }
    }

    private void resetCrafting() {
        this.isCrafting = false;
        this.progress = 0;
        this.warmupTimer = 0.0f;
    }

    private boolean validatePedestalItems(List<ItemStack> currentItems) {
        ArrayList<ItemStack> previousItems = new ArrayList<ItemStack>();
        if (this.level == null) {
            return false;
        }
        for (IMalumSpecialItemAccessPoint pedestal : AltarCraftingHelper.capturePedestals((Level)this.level, (BlockPos)this.worldPosition)) {
            ItemStack stack = pedestal.getSuppliedInventory().getStackInSlot(0);
            if (stack.isEmpty() || stack.is(Items.ENCHANTED_BOOK) || !stack.isEnchanted()) continue;
            previousItems.add(stack);
        }
        return currentItems.equals(previousItems);
    }

    private List<ItemStack> collectEnchantedItems() {
        ArrayList<ItemStack> enchantedItems = new ArrayList<ItemStack>();
        if (this.level == null) {
            return enchantedItems;
        }
        List pedestals = AltarCraftingHelper.capturePedestals((Level)this.level, (BlockPos)this.worldPosition);
        for (IMalumSpecialItemAccessPoint pedestal : pedestals) {
            ItemStack stack = pedestal.getSuppliedInventory().getStackInSlot(0);
            if (stack.isEmpty() || stack.is(Items.ENCHANTED_BOOK) || !stack.isEnchanted()) continue;
            enchantedItems.add(stack);
        }
        return enchantedItems;
    }

    private List<ItemStack> collectEnchantedItemsFromPedestal() {
        ArrayList<ItemStack> enchantedItems = new ArrayList<ItemStack>();
        if (this.level == null) {
            return enchantedItems;
        }
        List pedestals = AltarCraftingHelper.capturePedestals((Level)this.level, (BlockPos)this.worldPosition);
        for (IMalumSpecialItemAccessPoint pedestal : pedestals) {
            ItemStack stack = pedestal.getSuppliedInventory().getStackInSlot(0);
            if (stack.isEmpty() || stack.is(Items.ENCHANTED_BOOK) || !stack.isEnchanted() || !this.isPedestalSoulwood(pedestal)) continue;
            enchantedItems.add(stack);
        }
        return enchantedItems;
    }

    private boolean isPedestalSoulwood(IMalumSpecialItemAccessPoint pedestal) {
        if (this.level == null) {
            return false;
        }
        Block block = this.level.getBlockState(pedestal.getAccessPointBlockPos()).getBlock();
        return block == MalumBlocks.ORNATE_SOULWOOD_ITEM_PEDESTAL.get() || block == MalumBlocks.TAINTED_ROCK_ITEM_PEDESTAL.get() || block == MalumBlocks.SOULWOOD_ITEM_PEDESTAL.get();
    }

    private boolean hasSpirit(Item spiritItem, int count) {
        int found = 0;
        for (int i = 0; i < this.spiritInventory.getSlots(); ++i) {
            ItemStack stack = this.spiritInventory.getStackInSlot(i);
            if (!stack.is(spiritItem) || (found += stack.getCount()) < count) continue;
            return true;
        }
        return false;
    }

    private boolean hasAllSpirits(int amount) {
        if (amount == 0) {
            ++amount;
        }
        for (Item spirit : SPIRIT_TYPES) {
            int found = 0;
            for (int i = 0; i < this.spiritInventory.getSlots(); ++i) {
                ItemStack stack = this.spiritInventory.getStackInSlot(i);
                if (!stack.is(spirit)) continue;
                found += stack.getCount();
            }
            if (found >= amount) continue;
            return false;
        }
        return true;
    }

    private void consumeSpirit(Item spiritItem, int count) {
        int remaining = count;
        for (int i = 0; i < this.spiritInventory.getSlots(); ++i) {
            ItemStack stack = this.spiritInventory.getStackInSlot(i);
            if (!stack.is(spiritItem)) continue;
            int take = Math.min(stack.getCount(), remaining);
            stack.shrink(take);
            if ((remaining -= take) > 0) continue;
            return;
        }
    }

    private void consumeAllSpirits(int amount) {
        block0: for (Item spirit : SPIRIT_TYPES) {
            int remaining = amount;
            for (int i = 0; i < this.spiritInventory.getSlots(); ++i) {
                ItemStack stack = this.spiritInventory.getStackInSlot(i);
                if (!stack.is(spirit)) continue;
                int take = Math.min(stack.getCount(), remaining);
                stack.shrink(take);
                if ((remaining -= take) <= 0) continue block0;
            }
        }
    }

    private void doExtraction(ServerLevel level, ItemStack book, List<ItemStack> items) {
        Object keys;
        HashMap<Holder, Integer> merged = new HashMap<Holder, Integer>();
        int spiritCost = 1;
        for (ItemStack itemStack : items) {
            ItemEnchantments enchants = (ItemEnchantments)itemStack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            enchants.entrySet().forEach(e -> merged.merge((Holder)e.getKey(), e.getIntValue(), Math::max));
            spiritCost += ((Integer)itemStack.getOrDefault(DataComponents.REPAIR_COST, (Object)0)).intValue();
        }
        List<ItemStack> soulwoodItems = this.collectEnchantedItemsFromPedestal();
        if (!soulwoodItems.isEmpty()) {
            for (ItemStack stack : soulwoodItems) {
                ItemEnchantments enchants = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                enchants.entrySet().forEach(e -> merged.remove(e.getKey()));
                spiritCost += ((Integer)stack.getOrDefault(DataComponents.REPAIR_COST, (Object)0)).intValue();
            }
        }
        if (merged.isEmpty()) {
            return;
        }
        spiritCost = Mth.clamp((int)spiritCost, (int)1, (int)64);
        boolean bl = this.hasSpirit((Item)MalumItems.UMBRAL_SPIRIT.get(), 1);
        if (!this.hasAllSpirits(spiritCost)) {
            return;
        }
        this.consumeAllSpirits(spiritCost);
        if (bl) {
            this.consumeSpirit((Item)MalumItems.UMBRAL_SPIRIT.get(), 1);
        }
        ItemStack result = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        merged.forEach((arg_0, arg_1) -> ((ItemEnchantments.Mutable)mutable).set(arg_0, arg_1));
        if (bl && !(keys = new ArrayList(merged.keySet())).isEmpty()) {
            Holder chosen = (Holder)keys.get(level.random.nextInt(keys.size()));
            int oldLvl = (Integer)merged.get(chosen);
            int boosted = Math.min(((Enchantment)chosen.value()).getMaxLevel() + 1, oldLvl + 1);
            mutable.set(chosen, boosted);
        }
        result.set(DataComponents.ENCHANTMENTS, (Object)mutable.toImmutable());
        this.inventory.setStackInSlot(0, result);
        for (ItemStack stack : items) {
            stack.remove(DataComponents.ENCHANTMENTS);
        }
        List<ColorParticleDataBuilder> spiritColors = Arrays.stream(SPIRIT_TYPES).filter(item -> item instanceof SpiritShardItem).map(item -> (SpiritShardItem)item).map(SpiritLike::createColorData).toList();
        List<SpiritLike> spirits = Arrays.stream(SPIRIT_TYPES).filter(item -> item instanceof SpiritShardItem).map(item -> (SpiritLike)item).toList();
        FusionAltarParticleEffects.craftItemParticles((Level)level, this, MalumNetworkedParticleEffectColorData.fromSpirits(spirits));
        List pedestalItems = AltarCraftingHelper.capturePedestals((Level)level, (BlockPos)this.worldPosition);
        if (pedestalItems != null) {
            for (IMalumSpecialItemAccessPoint provider : pedestalItems) {
                ItemStack stack = provider.getSuppliedInventory().getStackInSlot(0);
                if (stack.isEmpty()) continue;
                level.playSound(null, provider.getAccessPointBlockPos(), (SoundEvent)MalumSoundEvents.ALTAR_CONSUME.get(), SoundSource.BLOCKS, 1.0f, 1.1f + level.random.nextFloat() * 0.5f);
                if (level.isClientSide) {
                    FusionAltarParticleEffects.eatItemParticles((Level)level, this, provider, MalumNetworkedParticleEffectColorData.fromColors(spiritColors), stack);
                }
                BlockStateHelper.updateAndNotifyState((Level)level, (BlockPos)provider.getAccessPointBlockPos());
            }
            this.progress = (int)((float)this.progress * 0.8f);
        }
        if (level.isClientSide) {
            MalumParticleEffectTypes.SPIRIT_ALTAR_CRAFTS.createEffect(this.worldPosition).color(spiritColors).spawn(level);
        }
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.ALTAR_CRAFT.get(), SoundSource.BLOCKS, 1.0f, Mth.nextFloat((RandomSource)level.random, (float)0.9f, (float)1.1f));
    }

    public float getSpinUp(Easing easing) {
        return this.warmupTimer > 30.0f ? 1.0f : easing.ease(this.warmupTimer / 30.0f, 0.0f, 1.0f, 1.0f);
    }

    public void recalibrateAccelerators() {
        this.speed = 1.0f;
        this.accelerators.clear();
        this.acceleratorPositions.clear();
        if (this.level == null) {
            return;
        }
        Collection nearby = BlockEntityHelper.getBlockEntities(IAltarAccelerator.class, (Level)this.level, (BlockPos)this.worldPosition, (int)4, (int)3, (int)4);
        HashMap<IAltarAccelerator.AltarAcceleratorType, Integer> typeCounts = new HashMap<IAltarAccelerator.AltarAcceleratorType, Integer>();
        for (IAltarAccelerator accelerator : nearby) {
            BlockPos blockPos;
            if (!accelerator.canAccelerate()) continue;
            int max = accelerator.getAcceleratorType().maximumEntries();
            int count = typeCounts.getOrDefault(accelerator.getAcceleratorType(), 0);
            if (count >= max) continue;
            this.accelerators.add(accelerator);
            if (accelerator instanceof LodestoneBlockEntity) {
                LodestoneBlockEntity lbe = (LodestoneBlockEntity)accelerator;
                blockPos = lbe.getBlockPos();
            } else {
                blockPos = this.worldPosition;
            }
            this.acceleratorPositions.add(blockPos);
            this.speed += accelerator.getAcceleration();
            typeCounts.put(accelerator.getAcceleratorType(), count + 1);
        }
    }

    public Vec3 getCentralItemOffset() {
        return ALTAR_ITEM_OFFSET;
    }

    public Vec3 getItemPos() {
        BlockPos blockPos = this.getBlockPos();
        Vec3 offset = this.getCentralItemOffset();
        return new Vec3((double)blockPos.getX() + offset.x, (double)blockPos.getY() + offset.y, (double)blockPos.getZ() + offset.z);
    }

    public Vec3 getSpiritItemOffset(int slot, float partialTicks) {
        float projectedSpiritSpin = this.spiritSpin + this.getSpinUp(Easing.SINE_IN_OUT) * 0.05f + this.speed * 0.5f;
        float lerpSpiritSpin = this.spiritSpin + partialTicks * (projectedSpiritSpin - this.spiritSpin);
        float distanceOscillation = Mth.sin((float)(lerpSpiritSpin / 20.0f % 6.28f)) * 0.025f;
        float distance = 1.0f - this.getSpinUp(Easing.SINE_OUT) * 0.25f + distanceOscillation;
        float height = 0.75f + this.getSpinUp(Easing.QUARTIC_OUT) * this.getSpinUp((Easing)Easing.BACK_OUT) * 0.5f;
        return VecHelper.rotatingRadialOffset((Vec3)new Vec3(0.5, (double)height, 0.5), (float)distance, (float)slot, (float)this.spiritAmount, (float)lerpSpiritSpin, (float)360.0f);
    }

    public void onBreak(@Nullable Player player) {
        if (this.level != null) {
            this.inventory.dumpItems(this.level, this.worldPosition);
            this.spiritInventory.dumpItems(this.level, this.worldPosition);
            this.extrasInventory.dumpItems(this.level, this.worldPosition);
        }
    }

    public ItemInteractionResult onUse(Player pPlayer, InteractionHand pHand) {
        Level var4 = this.level;
        if (var4 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)var4;
            ItemStack result = this.inventory.interact(serverLevel, pPlayer, pHand);
            if (!result.isEmpty()) {
                return ItemInteractionResult.SUCCESS;
            }
            ItemStack spiritResult = this.spiritInventory.interact(serverLevel, pPlayer, pHand);
            return !spiritResult.isEmpty() ? ItemInteractionResult.SUCCESS : super.onUse(pPlayer, pHand);
        }
        return ItemInteractionResult.CONSUME;
    }

    public IItemHandler getInventory(Direction direction) {
        return this.inventory;
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        compound.putInt("progress", this.progress);
        compound.putInt("idleProgress", this.idleProgress);
        compound.putFloat("warmupTimer", this.warmupTimer);
        compound.putFloat("speed", this.speed);
        compound.putFloat("spiritAmount", this.spiritAmount);
        CompoundTag acceleratorData = new CompoundTag();
        acceleratorData.putInt("acceleratorAmount", this.acceleratorPositions.size());
        for (int i = 0; i < this.acceleratorPositions.size(); ++i) {
            acceleratorData.put("acceleratorPosition_" + i, (Tag)NBTHelper.saveBlockPos((BlockPos)this.acceleratorPositions.get(i)));
        }
        compound.put("acceleratorData", (Tag)acceleratorData);
        this.inventory.save(pRegistries, compound);
        this.spiritInventory.save(pRegistries, compound, "spiritInventory");
        this.extrasInventory.save(pRegistries, compound, "extrasInventory");
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        this.progress = compound.getInt("progress");
        this.idleProgress = compound.getInt("idleProgress");
        this.warmupTimer = compound.getFloat("warmupTimer");
        this.speed = compound.getFloat("speed");
        this.spiritAmount = compound.getFloat("spiritAmount");
        this.acceleratorPositions.clear();
        this.accelerators.clear();
        CompoundTag acceleratorData = compound.getCompound("acceleratorData");
        int amount = acceleratorData.getInt("acceleratorAmount");
        for (int i = 0; i < amount; ++i) {
            BlockEntity var8;
            BlockPos pos = NBTHelper.readBlockPos((CompoundTag)acceleratorData.getCompound("acceleratorPosition_" + i));
            if (pos == null || this.level == null || !((var8 = this.level.getBlockEntity(pos)) instanceof IAltarAccelerator)) continue;
            IAltarAccelerator accelerator = (IAltarAccelerator)var8;
            this.acceleratorPositions.add(pos);
            this.accelerators.add(accelerator);
        }
        this.inventory.load(pRegistries, compound);
        this.spiritInventory.load(pRegistries, compound, "spiritInventory");
        this.extrasInventory.load(pRegistries, compound, "extrasInventory");
        if (this.level != null) {
            this.recalculateCost();
            this.recalibrateAccelerators();
            if (this.level.isClientSide && this.isCrafting) {
                AltarSoundInstance.playSound((SpiritAltarBlockEntity)this);
            }
        }
        super.loadAdditional(compound, pRegistries);
    }
}

