/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.registry.common.block;

import com.mojang.datafixers.types.Type;
import com.sammy.malum.client.renderer.block.SpiritAltarRenderer;
import com.sammy.malum.registry.common.block.MalumBlocks;
import com.strawberry.gaze.common.block.curiosities.fusion_altar.FusionAltarBlockEntity;
import com.strawberry.gaze.registry.common.block.GazeBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import team.lodestar.lodestone.systems.blockentity.IItemHandlerSupplier;

public class GazeBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"gaze");
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<FusionAltarBlockEntity>> FUSION_ALTAR = BLOCK_ENTITY_TYPES.register("enchantment_workbench", () -> BlockEntityType.Builder.of(FusionAltarBlockEntity::new, (Block[])new Block[]{(Block)GazeBlocks.FUSION_ALTAR.get()}).build((Type)null));

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)FUSION_ALTAR.get(), (rec$, x$0) -> ((IItemHandlerSupplier)rec$).getInventory(x$0));
    }

    public static Block[] getBlocks(Class<?> ... blockClasses) {
        Collection blocks = MalumBlocks.BLOCKS.getEntries();
        ArrayList<Block> matchingBlocks = new ArrayList<Block>();
        for (DeferredHolder registryObject : blocks) {
            if (!registryObject.isBound() || !Arrays.stream(blockClasses).anyMatch(b -> b.isInstance(registryObject.get()))) continue;
            matchingBlocks.add((Block)registryObject.get());
        }
        return matchingBlocks.toArray(new Block[0]);
    }

    public static Block[] getBlocksExact(Class<?> clazz) {
        Collection blocks = MalumBlocks.BLOCKS.getEntries();
        ArrayList<Block> matchingBlocks = new ArrayList<Block>();
        for (DeferredHolder registryObject : blocks) {
            if (!clazz.equals(((Block)registryObject.get()).getClass())) continue;
            matchingBlocks.add((Block)registryObject.get());
        }
        return matchingBlocks.toArray(new Block[0]);
    }

    @EventBusSubscriber(modid="gaze", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class ClientOnly {
        @SubscribeEvent
        public static void registerRenderer(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)FUSION_ALTAR.get(), SpiritAltarRenderer::new);
        }
    }
}

