/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.client.render.element;

import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.common.guielement.ProgressBarGuiElement;
import fr.frinn.custommachinery.impl.guielement.AbstractTexturedGuiElement;
import fr.frinn.custommachinery.impl.guielement.TexturedGuiElementWidget;
import fr.frinn.custommachinery.impl.util.TextureInfo;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.common.guielement.HeatGuiElement;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import mekanism.api.IIncrementalEnum;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class HeatGuiElementWidget
extends TexturedGuiElementWidget<HeatGuiElement> {
    public HeatGuiElementWidget(HeatGuiElement element, IMachineScreen screen) {
        super((AbstractTexturedGuiElement)element, screen, (Component)Component.literal((String)"Heat"));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        double percent = this.getScreen().getTile().getComponentManager().getComponent(Registration.HEAT_MACHINE_COMPONENT.get()).map(component -> Math.max((component.getTemperature(0) - ((HeatGuiElement)this.getElement()).getMin()) / ((HeatGuiElement)this.getElement()).getMax(), 0.0)).orElse(0.0);
        ClientHandler.renderOrientedProgressTextures((GuiGraphics)graphics, (TextureInfo)((HeatGuiElement)this.getElement()).getEmptyTexture(), (TextureInfo)((HeatGuiElement)this.getElement()).getFilledTexture(), (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height, (double)percent, (ProgressBarGuiElement.Orientation)((HeatGuiElement)this.getElement()).getOrientation());
        if (this.isHovered() && ((HeatGuiElement)this.getElement()).highlight()) {
            ClientHandler.renderSlotHighlight((GuiGraphics)graphics, (int)(this.getX() + 1), (int)(this.getY() + 1), (int)(this.width - 2), (int)(this.height - 2));
        }
    }

    public List<Component> getTooltips() {
        return this.getScreen().getTile().getComponentManager().getComponent(Registration.HEAT_MACHINE_COMPONENT.get()).map(component -> List.of(MekanismLang.TEMPERATURE.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)component.getTemperature(0), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), MekanismLang.DISSIPATED_RATE.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)component.getLastEnvironmentalLoss(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false)}), MekanismLang.UNIT.translate(new Object[]{MekanismConfig.common.tempUnit.get()}))).orElse(Collections.emptyList());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isHoveredOrFocused()) {
            return false;
        }
        if (button == 0) {
            this.updateTemperatureUnit(IIncrementalEnum::getNext);
        } else if (button == 1) {
            this.updateTemperatureUnit(IIncrementalEnum::getPrevious);
        }
        return true;
    }

    private void updateTemperatureUnit(UnaryOperator<UnitDisplayUtils.TemperatureUnit> converter) {
        UnitDisplayUtils.TemperatureUnit updated;
        UnitDisplayUtils.TemperatureUnit current = (UnitDisplayUtils.TemperatureUnit)MekanismConfig.common.tempUnit.get();
        if (current != (updated = (UnitDisplayUtils.TemperatureUnit)converter.apply(current))) {
            MekanismConfig.common.tempUnit.set((Object)updated);
            MekanismConfig.common.save();
        }
    }
}

