/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.blockhuds;

import com.mojang.blaze3d.platform.Window;
import de.ellpeck.actuallyadditions.mod.blocks.blockhuds.IBlockHud;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityVerticalDigger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MinerHud
implements IBlockHud {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void displayHud(GuiGraphics guiGraphics, Minecraft minecraft, Player player, ItemStack stack, HitResult rayCast, Window resolution) {
        if (!(rayCast instanceof BlockHitResult)) {
            return;
        }
        BlockEntity tile = minecraft.level.getBlockEntity(((BlockHitResult)rayCast).getBlockPos());
        if (tile instanceof TileEntityVerticalDigger) {
            TileEntityVerticalDigger miner = (TileEntityVerticalDigger)tile;
            String info = miner.checkY == 0 ? "Done Mining!" : (miner.checkY == -1 ? "Calculating positions..." : "Mining at " + (miner.getBlockPos().getX() + miner.checkX) + ", " + miner.checkY + ", " + (miner.getBlockPos().getZ() + miner.checkZ) + ".");
            guiGraphics.drawString(minecraft.font, info, (int)((float)resolution.getGuiScaledWidth() / 2.0f + 5.0f), (int)((float)resolution.getGuiScaledHeight() / 2.0f - 20.0f), 0xFFFFFF);
        }
    }
}

