/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.blockhuds;

import com.mojang.blaze3d.platform.Window;
import de.ellpeck.actuallyadditions.mod.blocks.blockhuds.IBlockHud;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPlayerInterface;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PlayerInterfaceHud
implements IBlockHud {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void displayHud(GuiGraphics guiGraphics, Minecraft minecraft, Player player, ItemStack stack, HitResult rayCast, Window resolution) {
        if (!(rayCast instanceof BlockHitResult)) {
            return;
        }
        BlockEntity tile = minecraft.level.getBlockEntity(((BlockHitResult)rayCast).getBlockPos());
        if (tile != null && tile instanceof TileEntityPlayerInterface) {
            TileEntityPlayerInterface face = (TileEntityPlayerInterface)tile;
            String name = face.playerName == null ? "Unknown" : face.playerName;
            guiGraphics.drawString(minecraft.font, "Bound to: " + String.valueOf(ChatFormatting.RED) + name, (int)((float)resolution.getGuiScaledWidth() / 2.0f + 5.0f), (int)((float)resolution.getGuiScaledHeight() / 2.0f + 5.0f), 0xFFFFFF);
            guiGraphics.drawString(minecraft.font, "UUID: " + String.valueOf(ChatFormatting.DARK_GREEN) + String.valueOf(face.connectedPlayer), (int)((float)resolution.getGuiScaledWidth() / 2.0f + 5.0f), (int)((float)resolution.getGuiScaledHeight() / 2.0f + 15.0f), 0xFFFFFF);
        }
    }
}

