/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.gen;

import com.mojang.datafixers.util.Pair;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.gen.ActuallyProcessorLists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

public class ActuallyVillages {
    private static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        Holder.Reference emptyProcessorList = processorListRegistry.getHolderOrThrow(ActuallyProcessorLists.ENGINEER_HOUSE_PROCESSOR_LIST_KEY);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.get(poolRL);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.legacy((String)nbtPieceRL, (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.rawTemplates);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.rawTemplates = listOfPieceEntries;
    }

    public static void modifyVillageStructures(ServerAboutToStartEvent event) {
        Registry templatePoolRegistry = (Registry)event.getServer().registryAccess().registry(Registries.TEMPLATE_POOL).orElseThrow();
        Registry processorListRegistry = (Registry)event.getServer().registryAccess().registry(Registries.PROCESSOR_LIST).orElseThrow();
        ActuallyVillages.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, ResourceLocation.tryParse((String)"minecraft:village/plains/houses"), "actuallyadditions:andrew_period_house", 10);
        ActuallyVillages.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, ResourceLocation.tryParse((String)"minecraft:village/snowy/houses"), "actuallyadditions:andrew_period_house", 10);
        ActuallyVillages.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, ResourceLocation.tryParse((String)"minecraft:village/savanna/houses"), "actuallyadditions:andrew_period_house", 10);
        ActuallyVillages.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, ResourceLocation.tryParse((String)"minecraft:village/taiga/houses"), "actuallyadditions:andrew_period_house", 10);
        ActuallyVillages.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, ResourceLocation.tryParse((String)"minecraft:village/desert/houses"), "actuallyadditions:andrew_period_house", 50);
        RuleProcessor cropProcessor = new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.WHEAT, 0.3f), (RuleTest)AlwaysTrueTest.INSTANCE, ActuallyBlocks.RICE.get().defaultBlockState()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.WHEAT, 0.25f), (RuleTest)AlwaysTrueTest.INSTANCE, ActuallyBlocks.COFFEE.get().defaultBlockState()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.WHEAT, 0.1f), (RuleTest)AlwaysTrueTest.INSTANCE, ActuallyBlocks.CANOLA.get().defaultBlockState()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.WHEAT, 0.05f), (RuleTest)AlwaysTrueTest.INSTANCE, ActuallyBlocks.FLAX.get().defaultBlockState())));
        ActuallyVillages.addNewRuleToProcessorList(ResourceLocation.tryParse((String)"minecraft:farm_plains"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(ResourceLocation.tryParse((String)"minecraft:farm_savanna"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(ResourceLocation.tryParse((String)"minecraft:farm_snowy"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(ResourceLocation.tryParse((String)"minecraft:farm_taiga"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(ResourceLocation.tryParse((String)"minecraft:farm_desert"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(ResourceLocation.tryParse((String)"repurposed_structures:villages/badlands/crop_replacement"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(ResourceLocation.tryParse((String)"repurposed_structures:villages/birch/crop_randomizer"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(ResourceLocation.tryParse((String)"repurposed_structures:villages/dark_forest/crop_randomizer"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(ResourceLocation.tryParse((String)"repurposed_structures:villages/giant_taiga/crop_randomizer"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(ResourceLocation.tryParse((String)"repurposed_structures:villages/jungle/crop_randomizer"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(ResourceLocation.tryParse((String)"repurposed_structures:villages/mountains/crop_randomizer"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(ResourceLocation.tryParse((String)"repurposed_structures:villages/oak/crop_randomizer"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        ActuallyVillages.addNewRuleToProcessorList(ResourceLocation.tryParse((String)"repurposed_structures:villages/swamp/crop_randomizer"), (StructureProcessor)cropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
    }

    private static void addNewRuleToProcessorList(ResourceLocation targetProcessorList, StructureProcessor processorToAdd, Registry<StructureProcessorList> processorListRegistry) {
        processorListRegistry.getOptional(targetProcessorList).ifPresent(processorList -> {
            ArrayList<StructureProcessor> newSafeList = new ArrayList<StructureProcessor>(processorList.list());
            newSafeList.add(processorToAdd);
            processorList.list = newSafeList;
        });
    }
}

