/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory;

import de.ellpeck.actuallyadditions.mod.inventory.ActuallyContainers;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotImmovable;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotItemHandlerUnconditioned;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.DrillItem;
import de.ellpeck.actuallyadditions.mod.items.ItemDrillUpgrade;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class ContainerDrill
extends AbstractContainerMenu {
    public static final int SLOT_AMOUNT = 5;
    private final ItemStackHandlerAA drillInventory = new ItemStackHandlerAA(5);
    private final Inventory inventory;

    public static ContainerDrill fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ContainerDrill(windowId, inv);
    }

    public ContainerDrill(int windowId, final Inventory inventory) {
        super(ActuallyContainers.DRILL_CONTAINER.get(), windowId);
        int i;
        this.inventory = inventory;
        for (i = 0; i < 5; ++i) {
            this.addSlot((Slot)new SlotItemHandlerUnconditioned(this, this.drillInventory, i, 44 + i * 18, 19){

                @Override
                public boolean mayPlace(ItemStack stack) {
                    Item item = stack.getItem();
                    if (item instanceof ItemDrillUpgrade) {
                        boolean mayPlace;
                        ItemDrillUpgrade upgrade = (ItemDrillUpgrade)item;
                        if (this.hasItemInOtherSlots(stack)) {
                            inventory.player.displayClientMessage((Component)Component.translatable((String)"tooltip.actuallyadditions.drill.already_installed").withStyle(ChatFormatting.RED), true);
                            return false;
                        }
                        switch (upgrade.type) {
                            case SPEED_II: {
                                boolean bl = this.hasItemInOtherSlots(ActuallyItems.DRILL_UPGRADE_SPEED.toStack());
                                break;
                            }
                            case SPEED_III: {
                                boolean bl = this.hasItemInOtherSlots(ActuallyItems.DRILL_UPGRADE_SPEED_II.toStack());
                                break;
                            }
                            case FORTUNE_II: {
                                boolean bl = this.hasItemInOtherSlots(ActuallyItems.DRILL_UPGRADE_FORTUNE.toStack());
                                break;
                            }
                            case FIVE_BY_FIVE: {
                                boolean bl = this.hasItemInOtherSlots(ActuallyItems.DRILL_UPGRADE_THREE_BY_THREE.toStack());
                                break;
                            }
                            default: {
                                boolean bl = mayPlace = true;
                            }
                        }
                        if (!mayPlace) {
                            inventory.player.displayClientMessage((Component)Component.translatable((String)"tooltip.actuallyadditions.drill.missing_tier").withStyle(ChatFormatting.RED), true);
                        }
                        return mayPlace;
                    }
                    return false;
                }

                @Override
                public boolean mayPickup(Player player) {
                    boolean mayPickup = super.mayPickup(player);
                    if (!mayPickup) {
                        return false;
                    }
                    Item item = this.getItem().getItem();
                    if (item instanceof ItemDrillUpgrade) {
                        ItemDrillUpgrade upgrade = (ItemDrillUpgrade)item;
                        switch (upgrade.type) {
                            case SPEED: {
                                boolean bl;
                                if (!this.hasItemInOtherSlots(ActuallyItems.DRILL_UPGRADE_SPEED_II.toStack()) && !this.hasItemInOtherSlots(ActuallyItems.DRILL_UPGRADE_SPEED_III.toStack())) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            case SPEED_II: {
                                boolean bl;
                                if (!this.hasItemInOtherSlots(ActuallyItems.DRILL_UPGRADE_SPEED_III.toStack())) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            case FORTUNE: {
                                boolean bl;
                                if (!this.hasItemInOtherSlots(ActuallyItems.DRILL_UPGRADE_FORTUNE_II.toStack())) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            case THREE_BY_THREE: {
                                boolean bl;
                                if (!this.hasItemInOtherSlots(ActuallyItems.DRILL_UPGRADE_FIVE_BY_FIVE.toStack())) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            default: {
                                boolean bl = mayPickup = true;
                            }
                        }
                        if (!mayPickup) {
                            player.displayClientMessage((Component)Component.translatable((String)"tooltip.actuallyadditions.drill.remove_highest").withStyle(ChatFormatting.YELLOW), true);
                        }
                        return mayPickup;
                    }
                    return true;
                }
            });
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 58 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (i == inventory.selected) {
                this.addSlot(new SlotImmovable((Container)inventory, i, 8 + i * 18, 116));
                continue;
            }
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 116));
        }
        ItemStack stack = inventory.getSelected();
        if (!stack.isEmpty() && stack.getItem() instanceof DrillItem) {
            DrillItem.loadSlotsFromNBT((IItemHandlerModifiable)this.drillInventory, inventory.getSelected());
        }
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int slot) {
        int inventoryStart = 5;
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot theSlot = (Slot)this.slots.get(slot);
        if (theSlot != null && theSlot.hasItem()) {
            ItemStack newStack = theSlot.getItem();
            ItemStack currentStack = newStack.copy();
            if (slot >= inventoryStart ? (newStack.getItem() instanceof ItemDrillUpgrade ? !this.moveItemStackTo(newStack, 0, 5, false) : (slot >= inventoryStart && slot <= inventoryEnd ? !this.moveItemStackTo(newStack, hotbarStart, hotbarEnd + 1, false) : slot >= inventoryEnd + 1 && slot < hotbarEnd + 1 && !this.moveItemStackTo(newStack, inventoryStart, inventoryEnd + 1, false))) : !this.moveItemStackTo(newStack, inventoryStart, hotbarEnd + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (newStack.isEmpty()) {
                theSlot.set(ItemStack.EMPTY);
            } else {
                theSlot.setChanged();
            }
            if (newStack.getCount() == currentStack.getCount()) {
                return ItemStack.EMPTY;
            }
            theSlot.onTake(player, newStack);
            return currentStack;
        }
        return ItemStack.EMPTY;
    }

    public void clicked(int slotId, int dragType, @Nonnull ClickType clickTypeIn, @Nonnull Player player) {
        if (clickTypeIn == ClickType.SWAP && dragType == this.inventory.selected) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public void removed(@Nonnull Player player) {
        ItemStack stack = this.inventory.getSelected();
        if (!stack.isEmpty() && stack.getItem() instanceof DrillItem) {
            DrillItem.writeSlotsToNBT((IItemHandler)this.drillInventory, this.inventory.getSelected());
        }
        super.removed(player);
    }

    public boolean stillValid(@Nonnull Player player) {
        return true;
    }
}

