/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityItemInterface;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.SlotlessableItemHandlerWrapper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class TileEntityItemInterfaceHopping
extends TileEntityItemInterface {
    private SlotlessableItemHandlerWrapper handlerToPullFrom;
    private SlotlessableItemHandlerWrapper handlerToPushTo;

    public TileEntityItemInterfaceHopping(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.ITEM_INTERFACE_HOPPING.getTileEntityType(), pos, state);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityItemInterfaceHopping) {
            TileEntityItemInterfaceHopping tile = (TileEntityItemInterfaceHopping)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityItemInterfaceHopping) {
            TileEntityItemInterfaceHopping tile = (TileEntityItemInterfaceHopping)t;
            tile.serverTick();
            if (level.getLevelData().getGameTime() % 10L == 0L) {
                AABB axisAlignedBB;
                List items;
                if (tile.handlerToPullFrom != null) {
                    WorldUtil.doItemInteraction(tile.handlerToPullFrom, tile.itemHandler, 4);
                } else if (level.getLevelData().getGameTime() % 20L == 0L && (items = level.getEntities((EntityTypeTest)EntityType.ITEM, axisAlignedBB = new AABB((double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 2), (double)(pos.getZ() + 1)), EntitySelector.ENTITY_STILL_ALIVE)) != null && !items.isEmpty()) {
                    for (ItemEntity item : items) {
                        if (item == null) continue;
                        if (ActuallyAdditions.commonCapsLoaded) {
                            Object object = tile.itemHandler.getSlotlessHandler();
                        }
                        Optional<IItemHandler> handler = Optional.ofNullable(tile.itemHandler.getNormalHandler());
                        handler.ifPresent(cap -> {
                            System.out.println(cap.getSlots());
                            for (int i = 0; i < cap.getSlots(); ++i) {
                                ItemStack left = cap.insertItem(i, item.getItem(), false);
                                item.setItem(left);
                                if (!left.isEmpty()) continue;
                                item.discard();
                                break;
                            }
                        });
                    }
                }
                if (tile.handlerToPushTo != null) {
                    WorldUtil.doItemInteraction(tile.itemHandler, tile.handlerToPushTo, 4);
                }
            }
        }
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        BlockEntity to;
        super.saveDataOnChangeOrWorldStart();
        this.handlerToPullFrom = null;
        this.handlerToPushTo = null;
        BlockEntity from = this.level.getBlockEntity(this.getBlockPos().relative(Direction.UP));
        if (from != null && !(from instanceof TileEntityItemInterface)) {
            IItemHandler normal = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, from.getBlockPos(), (Object)Direction.DOWN);
            Object slotless = null;
            this.handlerToPullFrom = new SlotlessableItemHandlerWrapper(normal, slotless);
        }
        BlockState state = this.level.getBlockState(this.getBlockPos());
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING_HOPPER);
        BlockPos toPos = this.getBlockPos().relative(facing);
        if (this.level.isLoaded(toPos) && (to = this.level.getBlockEntity(toPos)) != null && !(to instanceof TileEntityItemInterface)) {
            IItemHandler normal = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, to.getBlockPos(), (Object)facing.getOpposite());
            Object slotless = null;
            this.handlerToPushTo = new SlotlessableItemHandlerWrapper(normal, slotless);
        }
    }
}

