/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.recipe;

import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.gate.GatewayRegistry;
import dev.shadowsoffire.gateways.item.GatePearlItem;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class GatewayRecipeSerializer
extends ShapedRecipe.Serializer {
    public static final MapCodec<ShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ShapedRecipe.Serializer.CODEC.forGetter(Function.identity()), (App)GatewayRegistry.INSTANCE.holderCodec().fieldOf("gateway").forGetter(GatewayRecipeSerializer::resolveGatewayHolder)).apply((Applicative)inst, GatewayRecipeSerializer::buildRecipe));

    public MapCodec<ShapedRecipe> codec() {
        return CODEC;
    }

    public static ShapedRecipe buildRecipe(ShapedRecipe recipe, DynamicHolder<Gateway> holder) {
        ItemStack gateway = recipe.getResultItem(null);
        if (!(gateway.getItem() instanceof GatePearlItem)) {
            throw new JsonSyntaxException("Gateway Recipe output must be a gate opener item.  Provided: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)gateway.getItem())));
        }
        GatePearlItem.setGate(gateway, holder);
        return recipe;
    }

    public static DynamicHolder<Gateway> resolveGatewayHolder(ShapedRecipe recipe) {
        ItemStack gateway = recipe.getResultItem(null);
        return GatePearlItem.getGate(gateway);
    }
}

