/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.blockentity;

import dev.su5ed.mffs.MFFSConfig;
import dev.su5ed.mffs.api.card.IdentificationCard;
import dev.su5ed.mffs.api.security.BiometricIdentifier;
import dev.su5ed.mffs.api.security.FieldPermission;
import dev.su5ed.mffs.blockentity.BaseBlockEntity;
import dev.su5ed.mffs.blockentity.FortronBlockEntity;
import dev.su5ed.mffs.menu.BiometricIdentifierMenu;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.setup.ModObjects;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.inventory.CopyingIdentificationCard;
import dev.su5ed.mffs.util.inventory.InventorySlot;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;

public class BiometricIdentifierBlockEntity
extends FortronBlockEntity
implements BiometricIdentifier {
    public final InventorySlot masterSlot = this.addSlot("master", InventorySlot.Mode.BOTH, ModUtil::isIdentificationCard);
    public final InventorySlot rightsSlot = this.addSlot("rights", InventorySlot.Mode.BOTH, ModUtil::isIdentificationCard);
    public final InventorySlot copySlot = this.addSlot("copy", InventorySlot.Mode.BOTH, ModUtil::isIdentificationCard, this::copyCard);
    public final List<InventorySlot> identitySlots = IntStreamEx.range((int)9).mapToObj(i -> this.addSlot("identity_" + i, InventorySlot.Mode.BOTH, ModUtil::isIdentificationCard)).toList();

    public BiometricIdentifierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends BaseBlockEntity>)((BlockEntityType)ModObjects.BIOMETRIC_IDENTIFIER_BLOCK_ENTITY.get()), pos, state);
    }

    @Override
    public Optional<IdentificationCard> getManipulatingCard() {
        return Optional.ofNullable((IdentificationCard)this.rightsSlot.getItem().getCapability(ModCapabilities.IDENTIFICATION_CARD)).map(card -> Optional.ofNullable((IdentificationCard)this.copySlot.getItem().getCapability(ModCapabilities.IDENTIFICATION_CARD)).map(copy -> new CopyingIdentificationCard((IdentificationCard)card, (IdentificationCard)copy)).orElse((IdentificationCard)card));
    }

    private void copyCard(ItemStack stack) {
        Optional.ofNullable((IdentificationCard)this.rightsSlot.getItem().getCapability(ModCapabilities.IDENTIFICATION_CARD)).ifPresent(card -> Optional.ofNullable((IdentificationCard)stack.getCapability(ModCapabilities.IDENTIFICATION_CARD)).ifPresent(card::copyTo));
    }

    @Override
    public void setActive(boolean active) {
        if (!this.masterSlot.isEmpty() || !active) {
            super.setActive(active);
        }
    }

    @Override
    public boolean isActive() {
        return !this.masterSlot.isEmpty() && super.isActive();
    }

    @Override
    protected void animate() {
        super.animate();
        if (!this.isActive()) {
            this.animation = 0;
        }
    }

    @Override
    public boolean isAccessGranted(Player player, FieldPermission permission) {
        return !this.isActive() || BiometricIdentifierBlockEntity.canOpBypass(player) || StreamEx.of((Object)this.masterSlot).append(this.identitySlots).anyMatch(slot -> {
            IdentificationCard card = (IdentificationCard)slot.getItem().getCapability(ModCapabilities.IDENTIFICATION_CARD);
            return card != null && card.checkIdentity(player);
        });
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new BiometricIdentifierMenu(containerId, this.worldPosition, player, playerInventory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canOpBypass(Player player) {
        if (!(player instanceof ServerPlayer)) return false;
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if ((Boolean)MFFSConfig.COMMON.allowOpBiometryOverride.get() == false) return false;
        if (!serverPlayer.server.getPlayerList().isOp(player.getGameProfile())) return false;
        return true;
    }
}

