/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbechoes.FTBEchoes;
import dev.ftb.mods.ftbechoes.echo.Echo;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class PersistedClientData {
    private static final Codec<Map<ResourceLocation, Set<Integer>>> COLLAPSED_CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.INT.listOf().xmap(HashSet::new, ArrayList::new)).xmap(HashMap::new, map -> {
        HashMap res = new HashMap();
        map.forEach((k, v) -> res.put(k, new HashSet(v)));
        return res;
    });
    public static final Codec<PersistedClientData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)COLLAPSED_CODEC.fieldOf("collapsed").forGetter(p -> p.collapsedStages)).apply((Applicative)builder, PersistedClientData::new));
    private static final String DATA_FILE = "clientdata-{id}.snbt";
    private static PersistedClientData INSTANCE;
    private boolean saveNeeded = true;
    private final Map<ResourceLocation, Set<Integer>> collapsedStages;

    private PersistedClientData(Map<ResourceLocation, Set<Integer>> collapsedStages) {
        this.collapsedStages = collapsedStages;
    }

    private static PersistedClientData createNew() {
        return new PersistedClientData(new HashMap<ResourceLocation, Set<Integer>>());
    }

    public static PersistedClientData get() {
        if (INSTANCE == null) {
            Path file = PersistedClientData.savePath();
            if (!Files.exists(file, new LinkOption[0])) {
                PersistedClientData.createNew().save();
            }
            try {
                SNBTCompoundTag tag = SNBT.tryRead((Path)file);
                INSTANCE = CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).resultOrPartial(arg_0 -> ((Logger)FTBEchoes.LOGGER).error(arg_0)).orElse(PersistedClientData.createNew());
            }
            catch (IOException e) {
                FTBEchoes.LOGGER.error("can't read {}, using default persisted client data", (Object)file);
                INSTANCE = PersistedClientData.createNew();
            }
        }
        return INSTANCE;
    }

    public void save() {
        if (this.saveNeeded) {
            Path file = PersistedClientData.savePath();
            try {
                Tag tag = (Tag)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).resultOrPartial(arg_0 -> ((Logger)FTBEchoes.LOGGER).error(arg_0)).orElse(new CompoundTag());
                if (tag instanceof CompoundTag) {
                    CompoundTag c = (CompoundTag)tag;
                    SNBT.tryWrite((Path)file, (CompoundTag)c);
                } else {
                    FTBEchoes.LOGGER.error("can't write {}, expected CompoundTag?", (Object)file);
                }
            }
            catch (IOException e) {
                FTBEchoes.LOGGER.error("can't write {}", (Object)file);
            }
            this.saveNeeded = false;
        }
    }

    public boolean isStageCollapsed(Echo echo, int stageIdx) {
        return this.collapsedStages.getOrDefault(echo.id(), Set.of()).contains(stageIdx);
    }

    public boolean setStageCollapsed(Echo echo, int stageIdx, boolean collapsed) {
        boolean c = this.isStageCollapsed(echo, stageIdx);
        if (c != collapsed) {
            Set set = this.collapsedStages.computeIfAbsent(echo.id(), k -> new HashSet());
            if (collapsed) {
                set.add(stageIdx);
            } else {
                set.remove(stageIdx);
            }
            this.saveNeeded = true;
            return true;
        }
        return false;
    }

    public static void refreshInstance() {
        INSTANCE = null;
    }

    private static Path savePath() {
        UUID teamId = FTBTeamsAPI.api().getClientManager().getManagerId();
        return ConfigUtil.LOCAL_DIR.resolve("ftbechoes").resolve(DATA_FILE.replace("{id}", teamId == null ? "default" : teamId.toString()));
    }
}

