/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbechoes.echo.Echo;
import dev.ftb.mods.ftbechoes.echo.EchoStage;
import dev.ftb.mods.ftbechoes.echo.progress.TeamProgress;
import dev.ftb.mods.ftbechoes.integration.quests.FTBQuestsIntegration;
import dev.ftb.mods.ftbechoes.shopping.ShopData;
import dev.ftb.mods.ftbechoes.shopping.ShoppingBasket;
import dev.ftb.mods.ftbechoes.shopping.ShoppingKey;
import dev.ftb.mods.ftbechoes.util.MiscUtil;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.ModUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class ShopItemWidget
extends Panel {
    public static final int WIDGET_SIZE = 64;
    public static final int INC_BTN_SIZE = 14;
    public static final int ICON_BTN_SIZE = 24;
    private final ShopData data;
    private final boolean unlocked;
    private final Button incrButton;
    private final Button decrButton;
    private final Button iconButton;
    private final ShoppingKey key;
    private final Component costStr;
    private final Component tooltip;
    private final boolean isCommand;
    private final TeamProgress teamProgress;
    private final Map<String, List<ItemStack>> byMod;
    @Nullable
    private List<Component> extraInfo = null;

    public ShopItemWidget(Panel parent, Echo echo, ShopData data, EchoStage stage, boolean unlocked, TeamProgress teamProgress) {
        super(parent);
        this.data = data;
        this.unlocked = unlocked;
        this.teamProgress = teamProgress;
        this.key = ShoppingKey.of(echo, data);
        this.costStr = MiscUtil.formatCost(data.cost());
        this.byMod = new HashMap<String, List<ItemStack>>();
        for (ItemStack stack : data.stacks()) {
            this.byMod.computeIfAbsent(this.getModForItem(stack), k -> new ArrayList()).add(stack);
        }
        this.tooltip = data.maxClaims().isPresent() && this.getRemainingLimit() <= 0 ? Component.translatable((String)"ftbechoes.tooltip.claimed") : (unlocked ? Component.translatable((String)"ftbechoes.tooltip.unlocked_by", (Object[])new Object[]{stage.title().copy().withStyle(ChatFormatting.GREEN)}).withStyle(ChatFormatting.GRAY) : Component.translatable((String)"ftbechoes.tooltip.locked"));
        this.setSize(64, 64);
        this.decrButton = new AdjustButton(this, false);
        this.incrButton = new AdjustButton(this, true);
        this.iconButton = new IconButton(this.getActualIcon());
        this.isCommand = data.command().isPresent();
        if (unlocked && ModList.get().isLoaded("ftbquests")) {
            this.extraInfo = FTBQuestsIntegration.getLootData(this.data);
        }
    }

    private String getModForItem(ItemStack stack) {
        if (BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString().equals("ftbquests:lootcrate")) {
            return "";
        }
        return ModUtils.getModName((Item)stack.getItem()).orElse("");
    }

    public void addWidgets() {
        this.add((Widget)this.decrButton);
        this.add((Widget)this.incrButton);
        this.add((Widget)this.iconButton);
    }

    public void alignWidgets() {
        this.decrButton.setPosAndSize(4, this.height - 18, 14, 14);
        this.incrButton.setPosAndSize(this.width - 18, this.height - 18, 14, 14);
        this.iconButton.setPosAndSize((this.width - 24) / 2, 16, 24, 24);
    }

    private void adjustAmount(int adjustment) {
        if (this.unlocked) {
            ShoppingBasket.CLIENT_INSTANCE.adjust(this.key, adjustment * (ScreenWrapper.hasShiftDown() ? 10 : 1), this.isCommand ? 1 : this.data.maxClaims().map(max -> this.getRemainingLimit()).orElse(Integer.MAX_VALUE));
        }
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        GuiHelper.drawBorderedPanel((GuiGraphics)graphics, (int)x, (int)y, (int)w, (int)h, (Color4I)Color4I.rgb((int)1843240), (boolean)true);
    }

    public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        super.draw(graphics, theme, x, y, w, h);
        MutableComponent amountStr = Component.literal((String)String.valueOf(ShoppingBasket.CLIENT_INSTANCE.get(this.key)));
        int sx = 16 + (32 - theme.getStringWidth((FormattedText)amountStr)) / 2;
        theme.drawString(graphics, (Object)amountStr, x + sx, y + this.height - 14, theme.getContentColor(WidgetType.NORMAL), 0);
        theme.drawString(graphics, (Object)this.costStr, x + this.width - theme.getStringWidth((FormattedText)this.costStr) - 4, y + 4, theme.getContentColor(WidgetType.NORMAL), 0);
        if (this.data.maxClaims().isPresent()) {
            PoseStack pose = graphics.pose();
            pose.pushPose();
            pose.translate((float)(x + 4), (float)(y + 4), 0.0f);
            pose.scale(0.75f, 0.75f, 1.0f);
            theme.drawString(graphics, (Object)Component.translatable((String)"ftbechoes.tooltip.stock"), 0, 0, theme.getContentColor(WidgetType.NORMAL).withAlpha(200), 0);
            pose.popPose();
            theme.drawString(graphics, (Object)Component.literal((String)String.valueOf(this.getRemainingLimit())), x + 4, y + 12, theme.getContentColor(WidgetType.NORMAL), 0);
        }
        if (!this.unlocked || this.data.maxClaims().isPresent() && this.getRemainingLimit() <= 0) {
            graphics.pose().translate(0.0f, 0.0f, 300.0f);
            Color4I.DARK_GRAY.withAlpha(160).draw(graphics, x, y, w, h);
            graphics.pose().translate(0.0f, 0.0f, -300.0f);
        }
    }

    public void addMouseOverText(TooltipList list) {
        if (this.getMouseY() < this.getY() + 16 && this.getMouseX() < this.getX() + this.width / 2 && this.data.maxClaims().isPresent()) {
            list.add((Component)Component.translatable((String)"ftbechoes.gui.stock_remaining", (Object[])new Object[]{this.getRemainingLimit(), this.data.maxClaims().get()}));
            list.add((Component)Component.translatable((String)("ftbechoes.gui.stock_limit." + (this.data.perPlayerMax() ? "player" : "team"))).withStyle(ChatFormatting.GRAY));
        } else {
            super.addMouseOverText(list);
        }
    }

    private Icon getActualIcon() {
        if (this.data.stacks().size() == 1) {
            return this.data.icon().orElse(ItemIcon.getItemIcon((ItemStack)this.data.stacks().getFirst()));
        }
        if (this.data.stacks().size() > 1) {
            return this.data.icon().orElse(IconAnimation.fromList(this.data.stacks().stream().map(ItemIcon::getItemIcon).toList(), (boolean)false));
        }
        return this.data.icon().orElse((Icon)Icon.empty());
    }

    int getRemainingLimit() {
        return this.data.maxClaims().map(max -> this.teamProgress.getRemainingShopStock((Player)Minecraft.getInstance().player, this.key, this.data)).orElse(Integer.MAX_VALUE);
    }

    private class AdjustButton
    extends SimpleTextButton {
        private final boolean forward;

        public AdjustButton(ShopItemWidget panel, boolean forward) {
            super((Panel)panel, (Component)Component.literal((String)(forward ? "+" : "-")), (Icon)Icon.empty());
            this.forward = forward;
        }

        public void onClicked(MouseButton mouseButton) {
            ShopItemWidget.this.adjustAmount(this.forward ? 1 : -1);
        }

        public boolean isEnabled() {
            return ShopItemWidget.this.unlocked && ((ShopItemWidget)this.parent).getRemainingLimit() > 0;
        }

        public WidgetType getWidgetType() {
            return ShopItemWidget.this.unlocked ? super.getWidgetType() : WidgetType.DISABLED;
        }
    }

    private class IconButton
    extends SimpleButton {
        public IconButton(Icon icon) {
            super((Panel)ShopItemWidget.this, (Component)Component.empty(), icon, (b, mb) -> {});
        }

        public void playClickSound() {
        }

        public void addMouseOverText(TooltipList list) {
            ShopItemWidget.this.byMod.forEach((modName, stacks) -> {
                stacks.forEach(s -> list.add(IconButton.stackDesc(s)));
                if (!modName.isEmpty()) {
                    list.add((Component)Component.literal((String)modName).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
                }
            });
            ShopItemWidget.this.data.command().ifPresent(cmd -> cmd.description().forEach(arg_0 -> ((TooltipList)list).add(arg_0)));
            ShopItemWidget.this.data.description().forEach(arg_0 -> ((TooltipList)list).add(arg_0));
            list.add((Component)Component.empty());
            list.add(ShopItemWidget.this.tooltip);
            if (ShopItemWidget.this.extraInfo != null) {
                list.add((Component)Component.empty());
                if (!ScreenWrapper.hasShiftDown()) {
                    list.add((Component)Component.translatable((String)"ftbechoes.tooltip.hold_shift_for_more").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                } else {
                    ShopItemWidget.this.extraInfo.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
                }
            }
        }

        private static Component stackDesc(ItemStack stack) {
            return stack.getCount() == 1 ? stack.getHoverName() : Component.literal((String)(stack.getCount() + " x ")).append(stack.getHoverName());
        }
    }
}

