/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.entity;

import dev.ftb.mods.ftbechoes.block.entity.EchoProjectorBlockEntity;
import dev.ftb.mods.ftbechoes.client.FTBEchoesClient;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class EchoEntity
extends Entity {
    private static final EntityDataAccessor<String> ECHO_ID = SynchedEntityData.defineId(EchoEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public EchoEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ECHO_ID, (Object)"ftbechoes:_none_");
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.getEntityData().set(ECHO_ID, (Object)compound.getString("echo_id"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putString("echo_id", (String)this.getEntityData().get(ECHO_ID));
    }

    public void setEchoId(@NotNull ResourceLocation echoId) {
        this.getEntityData().set(ECHO_ID, (Object)echoId.toString());
    }

    @NotNull
    public ResourceLocation getEchoId() {
        return ResourceLocation.parse((String)((String)this.getEntityData().get(ECHO_ID)));
    }

    public void tick() {
        block3: {
            block2: {
                BlockEntity blockEntity = this.level().getBlockEntity(this.blockPosition());
                if (!(blockEntity instanceof EchoProjectorBlockEntity)) break block2;
                EchoProjectorBlockEntity projector = (EchoProjectorBlockEntity)blockEntity;
                if (this.getEchoId().equals((Object)projector.getEchoId())) break block3;
            }
            this.discard();
        }
    }

    public boolean isPickable() {
        return true;
    }

    public boolean canBeHitByProjectile() {
        return false;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        BlockEntity blockEntity;
        if (player.level().isClientSide && (blockEntity = this.level().getBlockEntity(this.blockPosition())) instanceof EchoProjectorBlockEntity) {
            EchoProjectorBlockEntity projector = (EchoProjectorBlockEntity)blockEntity;
            FTBEchoesClient.openEchoScreen(projector);
        }
        return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
    }
}

