/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.net;

import dev.ftb.mods.ftbechoes.FTBEchoes;
import dev.ftb.mods.ftbechoes.net.PlaceOrderResponseMessage;
import dev.ftb.mods.ftbechoes.shopping.ShoppingBasket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PlaceOrderMessage(ShoppingBasket basket) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, PlaceOrderMessage> STREAM_CODEC = StreamCodec.composite(ShoppingBasket.STREAM_CODEC, PlaceOrderMessage::basket, PlaceOrderMessage::new);
    public static final CustomPacketPayload.Type<PlaceOrderMessage> TYPE = new CustomPacketPayload.Type(FTBEchoes.id("place_order"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleData(PlaceOrderMessage message, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            ShoppingBasket validatedBasket = message.basket.validate(sp);
            if (FTBEchoes.currencyProvider().takeCurrency((Player)sp, validatedBasket.getTotalCost())) {
                validatedBasket.giveTo(sp);
                PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)PlaceOrderResponseMessage.ok(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)PlaceOrderResponseMessage.failed((Component)Component.translatable((String)"ftbechoes.tooltip.too_expensive")), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

