/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.net;

import dev.ftb.mods.ftbechoes.FTBEchoes;
import dev.ftb.mods.ftbechoes.echo.progress.TeamProgress;
import dev.ftb.mods.ftbechoes.echo.progress.TeamProgressManager;
import dev.ftb.mods.ftbechoes.net.ReturnTeamProgressToScreenMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record RequestTeamProgressMessage(UUID teamId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestTeamProgressMessage> TYPE = new CustomPacketPayload.Type(FTBEchoes.id("request_team_progress"));
    public static final StreamCodec<ByteBuf, RequestTeamProgressMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, RequestTeamProgressMessage::teamId, RequestTeamProgressMessage::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleData(RequestTeamProgressMessage message, IPayloadContext context) {
        Optional<TeamProgress> progress = TeamProgressManager.get().getProgress((ServerPlayer)context.player());
        if (progress.isEmpty()) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)context.player()), (CustomPacketPayload)new ReturnTeamProgressToScreenMessage(message.teamId, null, List.of()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        TeamProgress teamProgress = progress.get();
        List referencedPlayerIds = teamProgress.perEcho().values().stream().flatMap(e -> e.claimedRewards().keySet().stream()).toList();
        ArrayList<ReturnTeamProgressToScreenMessage.PlayerNameEntry> referencedPlayers = new ArrayList<ReturnTeamProgressToScreenMessage.PlayerNameEntry>();
        for (UUID playerId : referencedPlayerIds) {
            MinecraftServer server = context.player().getServer();
            if (server == null || server.getProfileCache() == null) continue;
            server.getProfileCache().get(playerId).ifPresent(profile -> referencedPlayers.add(new ReturnTeamProgressToScreenMessage.PlayerNameEntry(playerId, (Component)Component.literal((String)profile.getName()))));
        }
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)context.player()), (CustomPacketPayload)new ReturnTeamProgressToScreenMessage(message.teamId, teamProgress, referencedPlayers), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

