/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.events;

import com.direwolf20.laserio.client.screens.LaserGuiGraphics;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.ComponentItemHandler;

public class EventTooltip {
    private static final int STACKS_PER_LINE = 5;

    private static void renderFilterStack(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y) {
        Minecraft mc = Minecraft.getInstance();
        LaserGuiGraphics laserGuiGraphics = new LaserGuiGraphics(mc, guiGraphics.bufferSource());
        laserGuiGraphics.renderItemScale(8.0f, itemStack, x, y);
        laserGuiGraphics.renderItemDecorations(mc.font, itemStack, x, y, null);
    }

    private static void renderTagStack(GuiGraphics guiGraphics, String tag, int x, int y) {
        ItemStack bucketStack;
        FluidStack drawFluidStack;
        List tagFluids;
        Minecraft mc = Minecraft.getInstance();
        List tagItems = BuiltInRegistries.ITEM.getTag(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)tag))).stream().flatMap(HolderSet.ListBacked::stream).toList();
        if (tagItems.size() > 0) {
            ItemStack drawStack = new ItemStack((Holder)tagItems.get((int)(mc.level.getGameTime() / 20L) % tagItems.size()));
            EventTooltip.renderFilterStack(guiGraphics, drawStack, x, y);
        }
        if ((tagFluids = BuiltInRegistries.FLUID.getTag(FluidTags.create((ResourceLocation)ResourceLocation.parse((String)tag))).stream().flatMap(HolderSet.ListBacked::stream).toList()).size() > 0 && !(drawFluidStack = new FluidStack((Holder)tagFluids.get((int)(mc.level.getGameTime() / 20L) % tagFluids.size()), 1000)).isEmpty() && !(bucketStack = new ItemStack((ItemLike)drawFluidStack.getFluid().getBucket(), 1)).isEmpty()) {
            EventTooltip.renderFilterStack(guiGraphics, bucketStack, x, y);
        }
    }

    public static class CopyPasteTooltipComponent
    implements ClientTooltipComponent {
        Data tooltipData;

        public CopyPasteTooltipComponent(Data tooltipComponent) {
            this.tooltipData = tooltipComponent;
        }

        public int getHeight() {
            return Screen.hasShiftDown() ? 10 * this.tooltipData.rows : 0;
        }

        public int getWidth(Font font) {
            return Screen.hasShiftDown() && this.tooltipData.filterData != null ? 45 : 0;
        }

        public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
            if (this.tooltipData.stack == null) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null || mc.player == null || !Screen.hasShiftDown()) {
                return;
            }
            if (this.tooltipData.filterData == null && this.tooltipData.tags == null) {
                return;
            }
            int bx = x - 3;
            int by = y - 6;
            int j = 0;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            if (this.tooltipData.stack.getItem() instanceof FilterTag) {
                for (int i = 0; i < this.tooltipData.tags.size(); ++i) {
                    int xx = bx + j % 5 * 9;
                    int yy = by + j / 5 * 10;
                    String tag = this.tooltipData.tags.get(i);
                    if (!tag.isEmpty()) {
                        EventTooltip.renderTagStack(guiGraphics, tag, xx, yy);
                    }
                    ++j;
                }
            } else {
                for (int i = 0; i < this.tooltipData.filterData.getSlots(); ++i) {
                    int xx = bx + j % 5 * 9;
                    int yy = by + j / 5 * 10;
                    ItemStack filterStack = this.tooltipData.filterData.getStackInSlot(i);
                    if (!filterStack.isEmpty()) {
                        EventTooltip.renderFilterStack(guiGraphics, filterStack, xx, yy);
                    }
                    ++j;
                }
            }
        }

        public static class Data
        implements TooltipComponent {
            public ItemStack stack;
            public ComponentItemHandler filterData;
            public List<String> tags;
            public int rows = 0;

            public Data(ItemStack stack) {
                this.stack = stack;
                if (stack.getItem() instanceof FilterBasic) {
                    this.filterData = FilterBasic.getInventory(stack);
                } else if (stack.getItem() instanceof FilterCount) {
                    this.filterData = FilterCount.getInventory(stack);
                } else if (stack.getItem() instanceof FilterTag) {
                    this.tags = FilterTag.getTags(stack);
                } else {
                    return;
                }
                if (stack.getItem() instanceof FilterTag) {
                    int itemStackMin = 0;
                    int itemStackMax = Math.min(15, this.tags.size());
                    this.tags = this.tags.subList(itemStackMin, itemStackMax);
                    this.tags.sort(Comparator.naturalOrder());
                    this.rows = (int)Math.ceil((double)this.tags.size() / 5.0);
                } else {
                    int slot;
                    for (slot = 0; slot < 5; ++slot) {
                        if (this.filterData.getStackInSlot(slot).isEmpty()) continue;
                        this.rows = 1;
                        break;
                    }
                    for (slot = 5; slot < 10; ++slot) {
                        if (this.filterData.getStackInSlot(slot).isEmpty()) continue;
                        this.rows = 2;
                        break;
                    }
                    for (slot = 10; slot < 15; ++slot) {
                        if (this.filterData.getStackInSlot(slot).isEmpty()) continue;
                        this.rows = 3;
                        break;
                    }
                }
            }
        }
    }
}

