/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.TurnTableBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TurnTableBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty INVERTED = BlockStateProperties.INVERTED;
    public static final BooleanProperty ROTATING = ModBlockProperties.ROTATING;

    public TurnTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)INVERTED, (Comparable)Boolean.valueOf(false))).setValue((Property)ROTATING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWER, INVERTED, ROTATING});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (this.updatePower(state, world, pos) && (Integer)world.getBlockState(pos).getValue((Property)POWER) != 0) {
            this.tryRotate(world, pos);
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        Direction myDir;
        Direction face = hitResult.getDirection();
        if (face != (myDir = (Direction)state.getValue((Property)FACING)) && face != myDir.getOpposite()) {
            float f = (Boolean)(state = (BlockState)state.cycle((Property)INVERTED)).getValue((Property)INVERTED) != false ? 0.55f : 0.5f;
            level.playSound(player, pos, SoundEvents.COMPARATOR_CLICK, SoundSource.BLOCKS, 0.3f, f);
            level.setBlock(pos, state, 6);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public boolean updatePower(BlockState state, Level world, BlockPos pos) {
        int currentPower;
        int bestNeighborSignal = world.getBestNeighborSignal(pos);
        if (bestNeighborSignal != (currentPower = ((Integer)state.getValue((Property)POWER)).intValue())) {
            world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(bestNeighborSignal))).setValue((Property)ROTATING, (Comparable)Boolean.valueOf(bestNeighborSignal != 0)), 6);
            return true;
        }
        return false;
    }

    private void tryRotate(Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TurnTableBlockTile) {
            TurnTableBlockTile te = (TurnTableBlockTile)blockEntity;
            te.tryRotate();
        }
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.neighborChanged(state, world, pos, neighborBlock, fromPos, moving);
        boolean powerChanged = this.updatePower(state, world, pos);
        if ((Integer)world.getBlockState(pos).getValue((Property)POWER) != 0 && (powerChanged || fromPos.equals((Object)pos.relative((Direction)state.getValue((Property)FACING))))) {
            this.tryRotate(world, pos);
        }
    }

    private static Vec3 rotateY(Vec3 vec, float deg) {
        if (deg == 0.0f) {
            return vec;
        }
        if (vec == Vec3.ZERO) {
            return vec;
        }
        double x = vec.x;
        double y = vec.y;
        double z = vec.z;
        float angle = deg * ((float)Math.PI / 180);
        double s = Math.sin(angle);
        double c = Math.cos(angle);
        return new Vec3(x * c + z * s, y, z * c - x * s);
    }

    public static int getPeriod(BlockState state) {
        return 60 - (Integer)state.getValue((Property)POWER) * 4 + 4;
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity e) {
        super.stepOn(world, pos, state, e);
        if (!CommonConfigs.Redstone.TURN_TABLE_ROTATE_ENTITIES.get().booleanValue()) {
            return;
        }
        if (!e.onGround()) {
            return;
        }
        if ((Integer)state.getValue((Property)POWER) != 0 && state.getValue((Property)FACING) == Direction.UP) {
            float period = TurnTableBlock.getPeriod(state) + 1;
            float angleIncrement = 90.0f / period;
            float increment = (Boolean)state.getValue((Property)INVERTED) != false ? angleIncrement : -1.0f * angleIncrement;
            Vec3 origin = new Vec3((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            Vec3 oldPos = e.position();
            Vec3 oldOffset = oldPos.subtract(origin);
            Vec3 newOffset = TurnTableBlock.rotateY(oldOffset, increment);
            Vec3 posDiff = origin.add(newOffset).subtract(oldPos);
            e.move(MoverType.SHULKER_BOX, posDiff);
            e.hurtMarked = true;
            if (e instanceof LivingEntity) {
                TurnTableBlockTile tile;
                int catTimer;
                BlockEntity blockEntity;
                Cat cat;
                LivingEntity entity = (LivingEntity)e;
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    Utils.awardAdvancement((ServerPlayer)player, (ResourceLocation)Supplementaries.res("husbandry/turn_table"));
                }
                e.setOnGround(false);
                float diff = e.getYHeadRot() - increment;
                e.setYBodyRot(diff);
                e.setYHeadRot(diff);
                entity.yHeadRotO = ((LivingEntity)e).yHeadRot;
                entity.setNoActionTime(20);
                if (e instanceof Cat && (cat = (Cat)e).isOrderedToSit() && !world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof TurnTableBlockTile && (catTimer = (tile = (TurnTableBlockTile)blockEntity).getCatTimer()) == 0) {
                    tile.setCat();
                    world.playSound(null, (double)pos.getX() + 0.5, (double)((float)pos.getY() + 1.0f), (double)pos.getZ() + 0.5, ModSounds.TOM.get(), SoundSource.BLOCKS, 0.85f, 1.0f);
                }
            }
            e.yRotO = e.getYRot();
            e.setYRot(e.getYRot() - increment);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new TurnTableBlockTile(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, ModRegistry.TURN_TABLE_TILE.get(), TurnTableBlockTile::tick);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        if (eventID == 0) {
            if (world.isClientSide && ClientConfigs.Blocks.TURN_TABLE_PARTICLES.get().booleanValue()) {
                Direction dir = (Direction)state.getValue((Property)FACING);
                BlockPos front = pos.relative(dir);
                if (((Boolean)state.getValue((Property)INVERTED)).booleanValue()) {
                    dir = dir.getOpposite();
                }
                world.addParticle((ParticleOptions)ModParticles.ROTATION_TRAIL_EMITTER.get(), (double)front.getX() + 0.5, (double)front.getY() + 0.5, (double)front.getZ() + 0.5, (double)dir.get3DDataValue(), 0.71, -1.0);
            }
            return true;
        }
        return super.triggerEvent(state, world, pos, eventID, eventParam);
    }
}

