/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration;

import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImage;
import io.github.mortuusars.exposure.client.render.image.ImageRenderer;
import io.github.mortuusars.exposure.client.render.image.RenderedImageInstance;
import io.github.mortuusars.exposure.client.render.photograph.PhotographStyle;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.item.AlbumItem;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.world.item.component.album.AlbumPage;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.misc.TField;
import net.mehvahdjukaar.moonlight.api.misc.TMethod;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ExposureCompatClient {
    private static final TMethod<ImageRenderer, RenderedImageInstance> GET_OR_CREATE_INSTANCE = TMethod.of(ImageRenderer.class, (String)"getOrCreateInstance", (Class[])new Class[]{RenderableImage.class});
    private static final TField<RenderedImageInstance, Boolean> REQUIRES_UPLOAD = TField.of(RenderedImageInstance.class, (String)"requiresUpload");
    private static final TField<RenderedImageInstance, ResourceLocation> TEXTURE_LOCATION = TField.of(RenderedImageInstance.class, (String)"textureLocation");
    private static final TMethod<RenderedImageInstance, Void> UPDATE_TEXTURE = TMethod.of(RenderedImageInstance.class, (String)"updateTexture", (Class[])new Class[0]);

    private static ResourceLocation getFrameTexture(ItemStack stack, Frame frame) {
        PhotographStyle style = PhotographStyle.of((ItemStack)stack);
        RenderableImage image = style.process(ExposureClient.renderedExposures().getOrCreate(frame));
        ImageRenderer imageRenderer = ExposureClient.imageRenderer();
        RenderedImageInstance texture = (RenderedImageInstance)GET_OR_CREATE_INSTANCE.invoke((Object)imageRenderer, new Object[]{image});
        ResourceLocation textureLocation = (ResourceLocation)TEXTURE_LOCATION.get((Object)texture);
        if (((Boolean)REQUIRES_UPLOAD.get((Object)texture)).booleanValue()) {
            UPDATE_TEXTURE.invoke((Object)texture, new Object[0]);
            REQUIRES_UPLOAD.set((Object)texture, (Object)false);
        }
        return textureLocation;
    }

    public static ResourceLocation getPictureTextureForRenderer(ItemStack stack, int page) {
        Item item;
        Item item2 = item = stack.getItem();
        Objects.requireNonNull(item2);
        Item item3 = item2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PhotographItem.class, StackedPhotographsItem.class, AlbumItem.class}, (Object)item3, n)) {
            case 0: {
                PhotographItem photographItem = (PhotographItem)item3;
                Frame frame = photographItem.getFrame(stack);
                return ExposureCompatClient.getFrameTexture(stack, frame);
            }
            case 1: {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)item3;
                List photos = stackedPhotographsItem.getPhotographs(stack);
                int size = photos.size();
                if (size <= 0) break;
                ItemAndStack frameItem = (ItemAndStack)photos.get(page % size);
                ItemStack s = frameItem.getItemStack();
                Frame frame = ((PhotographItem)frameItem.getItem()).getFrame(s);
                return ExposureCompatClient.getFrameTexture(s, frame);
            }
            case 2: {
                AlbumItem album = (AlbumItem)item3;
                List content = album.getContent(stack).pages();
                List<ItemStack> photos = content.stream().map(AlbumPage::photograph).filter(p -> p.getItem() instanceof PhotographItem).toList();
                if (photos.isEmpty()) break;
                ItemStack s = photos.get(page % photos.size());
                PhotographItem photographItem = (PhotographItem)s.getItem();
                Frame frame = photographItem.getFrame(s);
                return ExposureCompatClient.getFrameTexture(s, frame);
            }
        }
        return null;
    }
}

