/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.tesseract.TesseractConfig;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.nio.file.Path;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class TesseractSaveHandler {
    private static long lastSaveTime = 0L;

    public static void registerListeners() {
        NeoForge.EVENT_BUS.addListener(TesseractSaveHandler::onJoin);
        NeoForge.EVENT_BUS.addListener(TesseractSaveHandler::tick);
        NeoForge.EVENT_BUS.addListener(TesseractSaveHandler::save);
        NeoForge.EVENT_BUS.addListener(TesseractSaveHandler::load);
    }

    private static void onJoin(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.getEntity().getCommandSenderWorld().isClientSide) {
            return;
        }
        TesseractTracker.sendReferences(e.getEntity());
        TesseractChannelManager.sendChannels(e.getEntity());
    }

    private static void tick(LevelTickEvent.Post e) {
        if (e.getLevel().isClientSide || e.getLevel().dimension() != Level.OVERWORLD) {
            return;
        }
        if (System.currentTimeMillis() - lastSaveTime >= (long)(TesseractConfig.saveInterval.get() * 60000)) {
            Path saveDirectory = CommonUtils.getServer().getWorldPath(LevelResource.ROOT);
            TesseractTracker.saveReferences(saveDirectory);
            TesseractChannelManager.saveChannels(saveDirectory);
            lastSaveTime = System.currentTimeMillis();
        }
    }

    private static void save(LevelEvent.Save e) {
        if (e.getLevel().isClientSide() || !(e.getLevel() instanceof Level) || ((Level)e.getLevel()).dimension() != Level.OVERWORLD) {
            return;
        }
        Path saveDirectory = CommonUtils.getServer().getWorldPath(LevelResource.ROOT);
        TesseractTracker.saveReferences(saveDirectory);
        TesseractChannelManager.saveChannels(saveDirectory);
        lastSaveTime = System.currentTimeMillis();
    }

    private static void load(LevelEvent.Load e) {
        if (e.getLevel().isClientSide() || !(e.getLevel() instanceof Level) || ((Level)e.getLevel()).dimension() != Level.OVERWORLD) {
            return;
        }
        Path saveDirectory = CommonUtils.getServer().getWorldPath(LevelResource.ROOT);
        TesseractTracker.loadReferences(saveDirectory);
        TesseractChannelManager.loadChannels(saveDirectory);
        lastSaveTime = System.currentTimeMillis();
    }
}

