/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.common.item;

import com.adonis.createshimmer.common.registry.CSEffects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ShimmerReagentItem
extends Item {
    public ShimmerReagentItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        Player player;
        super.finishUsingItem(stack, level, entity);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        }
        if (!level.isClientSide) {
            entity.addEffect(new MobEffectInstance(CSEffects.SHIMMER_EFFECT, 300, 0));
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (!player.getAbilities().instabuild) {
                if (stack.isEmpty()) {
                    return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                }
                if (!player.getInventory().add(new ItemStack((ItemLike)Items.GLASS_BOTTLE))) {
                    player.drop(new ItemStack((ItemLike)Items.GLASS_BOTTLE), false);
                }
            }
        }
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 12;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public SoundEvent getDrinkingSound() {
        return SoundEvents.GENERIC_DRINK;
    }

    public SoundEvent getEatingSound() {
        return SoundEvents.GENERIC_DRINK;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }
}

