/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.mobs.InvaderSpawnRules;
import dev.shadowsoffire.apotheosis.mobs.util.SurfaceType;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.data.DataMapProvider;

public class ApothDataMapProvider
extends DataMapProvider {
    private static final ResourceLocation TWILIGHT_FOREST = ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"twilight_forest_type");

    public ApothDataMapProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    protected void gather(HolderLookup.Provider provider) {
        DataMapProvider.Builder invaderRules = this.builder(Apoth.DataMaps.INVADER_SPAWN_RULES);
        invaderRules.add(BuiltinDimensionTypes.OVERWORLD, (Object)new InvaderSpawnRules(Map.of(WorldTier.HAVEN, Float.valueOf(0.0f), WorldTier.FRONTIER, Float.valueOf(0.018f), WorldTier.ASCENT, Float.valueOf(0.02f), WorldTier.SUMMIT, Float.valueOf(0.025f), WorldTier.PINNACLE, Float.valueOf(0.03f)), Optional.empty(), SurfaceType.NEEDS_SKY_OR_SAME_VERTICAL_SLICE), false, new ICondition[0]);
        invaderRules.add(BuiltinDimensionTypes.NETHER, (Object)new InvaderSpawnRules(Map.of(WorldTier.HAVEN, Float.valueOf(0.0f), WorldTier.FRONTIER, Float.valueOf(0.025f), WorldTier.ASCENT, Float.valueOf(0.027f), WorldTier.SUMMIT, Float.valueOf(0.03f), WorldTier.PINNACLE, Float.valueOf(0.035f)), Optional.empty(), SurfaceType.ANY), false, new ICondition[0]);
        invaderRules.add(BuiltinDimensionTypes.END, (Object)new InvaderSpawnRules(Map.of(WorldTier.HAVEN, Float.valueOf(0.0f), WorldTier.FRONTIER, Float.valueOf(0.018f), WorldTier.ASCENT, Float.valueOf(0.02f), WorldTier.SUMMIT, Float.valueOf(0.025f), WorldTier.PINNACLE, Float.valueOf(0.03f)), Optional.empty(), SurfaceType.SURFACE_OUTER_END), false, new ICondition[0]);
        invaderRules.add(TWILIGHT_FOREST, (Object)new InvaderSpawnRules(Map.of(WorldTier.HAVEN, Float.valueOf(0.0f), WorldTier.FRONTIER, Float.valueOf(0.05f), WorldTier.ASCENT, Float.valueOf(0.053f), WorldTier.SUMMIT, Float.valueOf(0.06f), WorldTier.PINNACLE, Float.valueOf(0.063f)), Optional.empty(), SurfaceType.NEEDS_SURFACE), false, new ICondition[]{new ModLoadedCondition(TWILIGHT_FOREST.getNamespace())});
        DataMapProvider.Builder catOverrides = this.builder(Apoth.DataMaps.LOOT_CATEGORY_OVERRIDES);
        catOverrides.add(BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.IRON_SWORD), (Object)Apoth.LootCategories.MELEE_WEAPON, false, new ICondition[0]);
        catOverrides.add(BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.SHULKER_SHELL), (Object)Apoth.LootCategories.NONE, false, new ICondition[0]);
    }
}

