/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.tiers;

import dev.shadowsoffire.apotheosis.compat.GameStagesCompat;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.CommonHooks;

public record GenContext(RandomSource rand, WorldTier tier, float luck, ResourceKey<Level> dimension, Holder<Biome> biome, Set<String> stages) {
    public static GenContext forPlayerAtPos(RandomSource rand, Player player, BlockPos pos) {
        Level level = player.level();
        return new GenContext(rand, WorldTier.getTier(player), player.getLuck(), (ResourceKey<Level>)level.dimension(), (Holder<Biome>)level.getBiome(pos), GameStagesCompat.getStages(player));
    }

    public static GenContext forPlayer(RandomSource rand, Player player) {
        return GenContext.forPlayerAtPos(rand, player, player.blockPosition());
    }

    public static GenContext forPlayer(Player player) {
        return GenContext.forPlayer(player.getRandom(), player);
    }

    @Nullable
    public static GenContext forLoot(LootContext ctx) {
        Player player = GenContext.findPlayer(ctx);
        if (player != null) {
            return new GenContext(ctx.getRandom(), WorldTier.getTier(player), ctx.getLuck(), (ResourceKey<Level>)ctx.getLevel().dimension(), (Holder<Biome>)ctx.getLevel().getBiome(player.blockPosition()), GameStagesCompat.getStages(player));
        }
        return null;
    }

    public static GenContext standalone(RandomSource rand, WorldTier tier, float luck, ServerLevel level, BlockPos pos) {
        return new GenContext(rand, tier, luck, (ResourceKey<Level>)level.dimension(), (Holder<Biome>)level.getBiome(pos), Set.of());
    }

    public static GenContext dummy(RandomSource rand) {
        return new GenContext(rand, WorldTier.HAVEN, 0.0f, (ResourceKey<Level>)Level.OVERWORLD, (Holder<Biome>)CommonHooks.resolveLookup((ResourceKey)Registries.BIOME).getOrThrow(Biomes.PLAINS), Set.of());
    }

    @Nullable
    public static Player findPlayer(LootContext ctx) {
        Object object = ctx.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (object instanceof Player) {
            Player p = (Player)object;
            return p;
        }
        object = ctx.getParamOrNull(LootContextParams.ATTACKING_ENTITY);
        if (object instanceof Player) {
            Player p = (Player)object;
            return p;
        }
        object = ctx.getParamOrNull(LootContextParams.DIRECT_ATTACKING_ENTITY);
        if (object instanceof Player) {
            Player p = (Player)object;
            return p;
        }
        if (ctx.getParamOrNull(LootContextParams.LAST_DAMAGE_PLAYER) != null) {
            return (Player)ctx.getParamOrNull(LootContextParams.LAST_DAMAGE_PLAYER);
        }
        return null;
    }

    @Override
    public final String toString() {
        return "GenContext[tier=%s, luck=%s, dimension=%s, biome=%s, stages=%s]".formatted(this.tier.getSerializedName(), Float.valueOf(this.luck), this.dimension.location(), this.biome.getKey().location(), this.stages);
    }
}

