/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.filter;

import com.supermartijn642.trashcans.filter.IFilterManager;
import com.supermartijn642.trashcans.filter.ItemFilter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class LiquidTrashCanFilters {
    private static final Map<String, IFilterManager> managers = new HashMap<String, IFilterManager>();

    public static void register(IFilterManager manager, String id) {
        managers.put(id, manager);
    }

    public static ItemFilter createFilter(ItemStack stack) {
        for (Map.Entry<String, IFilterManager> entry : managers.entrySet()) {
            ItemFilter filter = entry.getValue().createFilter(stack);
            if (filter == null || !filter.isValid()) continue;
            filter.setId(entry.getKey());
            return filter;
        }
        return null;
    }

    public static CompoundTag write(ItemFilter filter, HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        compound.putString("id", filter.getId());
        compound.put("filter", filter.write(provider));
        return compound;
    }

    public static ItemFilter read(CompoundTag compound, HolderLookup.Provider provider) {
        String id = compound.getString("id");
        if (managers.containsKey(id)) {
            ItemFilter filter = managers.get(id).readFilter(compound.getCompound("filter"), provider);
            filter.setId(id);
            return filter.isValid() ? filter : null;
        }
        return null;
    }
}

