/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.autocrafting;

import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.autocrafting.PlatformPatternProviderExternalPatternSink;
import com.ultramega.refinedtypes.type.TypeStack;
import com.ultramega.refinedtypes.type.source.SourceCapabilityCache;
import com.ultramega.refinedtypes.type.source.SourceResource;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SourcePatternProviderExternalPatternSink
implements PlatformPatternProviderExternalPatternSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourcePatternProviderExternalPatternSink.class);
    private final SourceCapabilityCache capabilityCache;

    SourcePatternProviderExternalPatternSink(SourceCapabilityCache capabilityCache) {
        this.capabilityCache = capabilityCache;
    }

    public ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action) {
        return this.capabilityCache.getCapability().map(handler -> this.accept(resources, action, (ISourceCap)handler)).orElse(ExternalPatternSink.Result.SKIPPED);
    }

    private ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action, ISourceCap handler) {
        for (ResourceAmount resource : resources) {
            ResourceKey resourceKey = resource.resource();
            if (!(resourceKey instanceof SourceResource)) continue;
            SourceResource sourceResource = (SourceResource)resourceKey;
            if (this.accept(action, handler, resource.amount(), sourceResource)) continue;
            return ExternalPatternSink.Result.REJECTED;
        }
        return ExternalPatternSink.Result.ACCEPTED;
    }

    private boolean accept(Action action, ISourceCap handler, long amount, SourceResource sourceResource) {
        long inserted = handler.receiveSource((int)amount, action == Action.SIMULATE);
        if (inserted != amount) {
            if (action == Action.EXECUTE) {
                LOGGER.warn("{} unexpectedly didn't accept all of {}, the remainder has been voided", (Object)handler, (Object)new TypeStack(sourceResource.type(), amount));
            }
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.capabilityCache.getCapability().map(handler -> handler.getSource() == 0).orElse(true);
    }
}

