/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.datagen;

import com.ultramega.refinedtypes.registry.Items;
import com.ultramega.refinedtypes.storage.energy.EnergyStorageVariant;
import com.ultramega.refinedtypes.storage.soul.SoulStorageVariant;
import com.ultramega.refinedtypes.storage.source.SourceStorageVariant;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemModelProviderImpl
extends ItemModelProvider {
    public ItemModelProviderImpl(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "refinedtypes", existingFileHelper);
    }

    protected void registerModels() {
        this.registerEnergyStoragePartsDisks();
        this.registerSourceStoragePartsDisks();
        this.registerSoulStoragePartsDisks();
    }

    private void registerEnergyStoragePartsDisks() {
        for (EnergyStorageVariant variant : EnergyStorageVariant.values()) {
            this.basicItem("energy", Items.getEnergyStoragePart(variant));
            this.basicItem("energy", Items.getEnergyStorageDisk(variant));
        }
    }

    private void registerSourceStoragePartsDisks() {
        for (SourceStorageVariant variant : SourceStorageVariant.values()) {
            this.basicItem("source", Items.getSourceStoragePart(variant));
            this.basicItem("source", Items.getSourceStorageDisk(variant));
        }
    }

    private void registerSoulStoragePartsDisks() {
        for (SoulStorageVariant variant : SoulStorageVariant.values()) {
            this.basicItem("soul", Items.getSoulStoragePart(variant));
            this.basicItem("soul", Items.getSoulStorageDisk(variant));
        }
    }

    public void basicItem(String subFolder, Item item) {
        ResourceLocation itemPath = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(itemPath.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)itemPath.getNamespace(), (String)("item/" + subFolder + "/" + itemPath.getPath())));
    }
}

