/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.grid.energy;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import com.ultramega.refinedtypes.type.energy.EnergyResourceType;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class EnergyGridExtractionStrategy
implements GridExtractionStrategy {
    private final AbstractContainerMenu menu;
    private final GridOperations gridOperations;

    public EnergyGridExtractionStrategy(AbstractContainerMenu containerMenu, ServerPlayer player, Grid grid) {
        this.menu = containerMenu;
        this.gridOperations = grid.createOperations((ResourceType)EnergyResourceType.INSTANCE, player);
    }

    public boolean onExtract(PlatformResourceKey resource, GridExtractMode extractMode, boolean cursor) {
        if (resource instanceof EnergyResource) {
            EnergyResource energyResource = (EnergyResource)resource;
            if (this.isEnergyContainerOnCursor()) {
                this.extractWithContainerOnCursor(energyResource, extractMode);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private ILongEnergyStorage getEnergyStorage(ItemStack stack) {
        return (ILongEnergyStorage)stack.getCapability(ILongEnergyStorage.ITEM);
    }

    private void extractWithContainerOnCursor(EnergyResource energyResource, GridExtractMode mode) {
        this.gridOperations.extract((ResourceKey)energyResource, mode, (resource, amount, action, source) -> {
            if (!(resource instanceof EnergyResource)) {
                return 0L;
            }
            ILongEnergyStorage destination = this.getEnergyStorage(this.menu.getCarried());
            if (destination == null) {
                return 0L;
            }
            return destination.receive(amount, action == Action.SIMULATE);
        });
    }

    private boolean isEnergyContainerOnCursor() {
        return this.getEnergyStorage(this.menu.getCarried()) != null;
    }
}

