/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.registry;

import com.ultramega.refinedtypes.networkenergizer.NetworkEnergizerBlock;
import com.ultramega.refinedtypes.storage.energy.EnergyStorageVariant;
import com.ultramega.refinedtypes.storage.soul.SoulStorageVariant;
import com.ultramega.refinedtypes.storage.source.SourceStorageVariant;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.Block;

public final class Blocks {
    private static final Map<EnergyStorageVariant, Supplier<Block>> ENERGY_STORAGE_BLOCKS = new EnumMap<EnergyStorageVariant, Supplier<Block>>(EnergyStorageVariant.class);
    private static final Map<SourceStorageVariant, Supplier<Block>> SOURCE_STORAGE_BLOCKS = new EnumMap<SourceStorageVariant, Supplier<Block>>(SourceStorageVariant.class);
    private static final Map<SoulStorageVariant, Supplier<Block>> SOUL_STORAGE_BLOCKS = new EnumMap<SoulStorageVariant, Supplier<Block>>(SoulStorageVariant.class);
    @Nullable
    private static Supplier<NetworkEnergizerBlock> networkEnergizer;

    private Blocks() {
    }

    public static Block getEnergyStorageBlock(EnergyStorageVariant variant) {
        return ENERGY_STORAGE_BLOCKS.get((Object)variant).get();
    }

    public static void setEnergyStorageBlock(EnergyStorageVariant variant, Supplier<Block> supplier) {
        ENERGY_STORAGE_BLOCKS.put(variant, supplier);
    }

    public static Block getSourceStorageBlock(SourceStorageVariant variant) {
        return SOURCE_STORAGE_BLOCKS.get((Object)variant).get();
    }

    public static void setSourceStorageBlock(SourceStorageVariant variant, Supplier<Block> supplier) {
        SOURCE_STORAGE_BLOCKS.put(variant, supplier);
    }

    public static Block getSoulStorageBlock(SoulStorageVariant variant) {
        return SOUL_STORAGE_BLOCKS.get((Object)variant).get();
    }

    public static void setSoulStorageBlock(SoulStorageVariant variant, Supplier<Block> supplier) {
        SOUL_STORAGE_BLOCKS.put(variant, supplier);
    }

    public static void setNetworkEnergizer(Supplier<NetworkEnergizerBlock> networkEnergizerSupplier) {
        networkEnergizer = networkEnergizerSupplier;
    }

    public static NetworkEnergizerBlock getNetworkEnergizer() {
        return Objects.requireNonNull(networkEnergizer).get();
    }
}

