/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class NbtSuggestions {
    public static int createdInstanceCounter = 0;
    public static final Multimap<String, NbtSuggestion> prefixFullMap = HashMultimap.create();
    public static final Multimap<String, NbtSuggestion> suffixFullMap = HashMultimap.create();
    public static final Multimap<String, NbtSuggestion> fullMap = HashMultimap.create();
    private final Map<String, NbtSuggestion> suggestions = new HashMap<String, NbtSuggestion>();
    private final boolean allowPredictions;

    public NbtSuggestions(boolean allowPredictions) {
        this.allowPredictions = allowPredictions;
        ++createdInstanceCounter;
    }

    public void add(NbtSuggestion suggestion) {
        String key = suggestion.tag;
        NbtSuggestion oldVal = this.suggestions.put(key, suggestion);
        if (!this.allowPredictions) {
            return;
        }
        String prefix = key.substring(0, NbtSuggestions.firstSeparator(key));
        String suffix = key.substring(NbtSuggestions.lastSeparator(key));
        if (oldVal != null) {
            prefixFullMap.remove((Object)prefix, (Object)oldVal);
            suffixFullMap.remove((Object)suffix, (Object)oldVal);
            fullMap.remove((Object)key, (Object)oldVal);
        }
        prefixFullMap.put((Object)prefix, (Object)suggestion);
        suffixFullMap.put((Object)suffix, (Object)suggestion);
        fullMap.put((Object)key, (Object)suggestion);
    }

    public void copyAll(NbtSuggestions nbtSuggestions, boolean prediction) {
        nbtSuggestions.getAll().forEach(suggestion -> this.add(suggestion.copy(prediction, nbtSuggestions, this)));
    }

    @Nullable
    public NbtSuggestion get(String key) {
        return this.suggestions.get(key);
    }

    public Collection<NbtSuggestion> getAll() {
        return this.suggestions.values();
    }

    private static int firstSeparator(String str) {
        for (int i = 1; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isUpperCase(c) && c != '_') continue;
            return i;
        }
        return str.length();
    }

    private static int lastSeparator(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c)) {
                return i;
            }
            if (c != '_') continue;
            return i + 1;
        }
        return 0;
    }
}

