/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.loader.typeloader;

import com.mt1006.nbt_ac.NBTac;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.loader.Loader;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.config.ModConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class Disassembly {
    private static final int MAX_DISASSEMBLY_DEPTH = 16;
    private static final String METHOD_LOAD_SIGNATURE = "(L" + CompoundTag.class.getName().replace('.', '/') + ";)V";
    private static final String METHOD_LOAD_BLOCK_SIGNATURE = "(L" + CompoundTag.class.getName().replace('.', '/') + ";L" + HolderLookup.Provider.class.getName().replace('.', '/') + ";)V";
    private static final String COMPOUND_TAG_SIGNATURE = CompoundTag.class.getName().replace('.', '/');
    private static final String LIST_TAG_SIGNATURE = ListTag.class.getName().replace('.', '/');
    private static final String COMPOUND_TAG_ARG_SIGNATURE = CompoundTag.class.getName();
    private static final String LIST_TAG_ARG_SIGNATURE = ListTag.class.getName();
    private static final String STRING_ARG_SIGNATURE = String.class.getName();
    private static final Map<String, ClassNode> classMap = new HashMap<String, ClassNode>();
    private static final Stack<String> disassemblingStack = new Stack();
    private static final Map<String, Template> fullTemplateMap = new HashMap<String, Template>();
    private static final Map<String, Template> partialTemplateMap = new HashMap<String, Template>();
    private static String blockEntityLoadMethod = null;

    public static void init() {
        try {
            MethodNode methodNode = Disassembly.loadMethod(Disassembly.loadClass(BlockEntity.class.getName(), null), null, METHOD_LOAD_BLOCK_SIGNATURE, 4, false);
            if (methodNode == null) {
                throw new Exception("Failed to find \"load\" method");
            }
            blockEntityLoadMethod = methodNode.name;
        }
        catch (Exception exception) {
            NBTac.LOGGER.error("Failed to initialize disassembler: {}", (Object)exception.toString());
            Loader.printStackTrace(exception);
        }
    }

    public static void clear() {
        classMap.clear();
        fullTemplateMap.clear();
        partialTemplateMap.clear();
    }

    public static ClassNode loadClass(String className, @Nullable Class<?> clazz) throws IOException {
        ClassReader reader;
        ClassNode existingNode = classMap.get(className = className.replace('/', '.'));
        if (existingNode != null) {
            return existingNode;
        }
        String classPath = className.replace('.', '/') + ".class";
        try {
            InputStream classStream;
            if (clazz == null) {
                clazz = Class.forName(className);
            }
            if ((classStream = clazz.getClassLoader().getResourceAsStream(classPath)) == null) {
                throw new ClassNotFoundException();
            }
            reader = new ClassReader(classStream);
            classStream.close();
        }
        catch (ClassNotFoundException exception) {
            throw new IOException("Class not found! - " + classPath);
        }
        ClassNode node = new ClassNode(589824);
        reader.accept((ClassVisitor)node, 0);
        classMap.put(className, node);
        return node;
    }

    @Nullable
    private static MethodNode loadMethod(ClassNode classNode, @Nullable String methodName, @Nullable String methodSignature, int accessFlags, boolean checkSuperclasses) {
        for (MethodNode methodNode : classNode.methods) {
            if (methodName != null && !methodName.equals(methodNode.name) || methodSignature != null && !methodSignature.equals(methodNode.desc) || accessFlags != 0 && (methodNode.access & accessFlags) == 0) continue;
            return methodNode;
        }
        if (checkSuperclasses) {
            if (classNode.superName == null || classNode.superName.equals("java/lang/Object")) {
                return null;
            }
            try {
                MethodNode node = Disassembly.loadMethod(Disassembly.loadClass(classNode.superName, null), methodName, methodSignature, accessFlags, true);
                if (node != null) {
                    return node;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                for (String interfaceName : classNode.interfaces) {
                    MethodNode node = Disassembly.loadMethod(Disassembly.loadClass(interfaceName, null), methodName, methodSignature, accessFlags, true);
                    if (node == null) continue;
                    return node;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void disassemblyEntity(Class<?> clazz, NbtSuggestions arg) throws Exception {
        Disassembly.disassemblyLoadMethod(Entity.class, null, METHOD_LOAD_SIGNATURE, 1, clazz, arg);
    }

    public static void disassemblyBlockEntity(Class<?> clazz, NbtSuggestions arg) throws Exception {
        Disassembly.disassemblyLoadMethod(clazz, blockEntityLoadMethod, METHOD_LOAD_BLOCK_SIGNATURE, 5, clazz, arg);
    }

    public static void disassemblyLoadMethod(Class<?> clazz, @Nullable String methodName, String methodSignature, int accessFlags, Class<?> objectClass, NbtSuggestions arg) throws Exception {
        Template templates = new Template();
        Disassembly.disassembly(clazz.getName(), methodName, methodSignature, accessFlags, objectClass.getName(), new MethodArgs(templates, null), 0, false, clazz);
        templates.applyTemplate(arg);
    }

    public static void disassembly(String className, @Nullable String methodName, String methodSignature, int accessFlags, @Nullable String objectClass, MethodArgs args, int depth, boolean uncertain, @Nullable Class<?> clazz) throws Exception {
        String methodID = String.format("%s %s %s", className, methodName, methodSignature);
        String methodFullID = String.format("%s %s", methodID, objectClass);
        if (disassemblingStack.contains(methodFullID)) {
            if (((Boolean)ModConfig.debugMode.val).booleanValue()) {
                NBTac.LOGGER.warn("Already disassembled! - {}", (Object)methodFullID);
            }
            return;
        }
        if (depth >= 16) {
            if (((Boolean)ModConfig.debugMode.val).booleanValue()) {
                NBTac.LOGGER.warn("Too deep! - {}", (Object)methodFullID);
            }
            return;
        }
        ClassNode classNode = Disassembly.loadClass(className, clazz);
        MethodNode method = Disassembly.loadMethod(classNode, methodName, methodSignature, accessFlags, true);
        if (method == null) {
            String methodInfo = methodName != null ? methodName : "with signature ";
            throw new Exception("Unable to find superclass of " + className + " containing method " + methodInfo + methodSignature);
        }
        disassemblingStack.push(methodFullID);
        Disassembly.readMethod(classNode, method, args, objectClass, depth, uncertain, methodID, methodFullID);
        disassemblingStack.pop();
    }

    private static void readMethod(ClassNode classNode, MethodNode methodNode, MethodArgs args, @Nullable String objectClass, int depth, boolean uncertain, String methodID, String methodFullID) throws Exception {
        List<Object> invokes;
        Template template;
        Template fullTemplate = fullTemplateMap.get(methodFullID);
        if (fullTemplate != null) {
            args.compound.merge(fullTemplate, args.string);
            return;
        }
        Template partialTemplate = partialTemplateMap.get(methodID);
        if (partialTemplate != null) {
            template = partialTemplate.copy(null, false, null);
            invokes = template.invokes != null ? template.invokes : List.of();
        } else {
            template = new Template();
            ValueTracker valueTracker = new ValueTracker(template, uncertain, false);
            Analyzer analyzer = new Analyzer((Interpreter)valueTracker);
            analyzer.analyze(classNode.name, methodNode);
            invokes = valueTracker.invokes;
            for (InvokeInfo invokeInfo : invokes) {
                if (invokeInfo.insn.getOpcode() == 182 || invokeInfo.calledOnThis) continue;
                Disassembly.disassembly(invokeInfo.insn.owner, invokeInfo.insn.name, invokeInfo.insn.desc, 0, null, invokeInfo.args, depth + 1, uncertain, null);
            }
            partialTemplateMap.put(methodID, template.copy(null, false, null));
        }
        for (InvokeInfo invokeInfo : invokes) {
            if (invokeInfo.insn.getOpcode() == 182) {
                if (invokeInfo.calledOnThis && objectClass != null) {
                    Disassembly.disassembly(objectClass, invokeInfo.insn.name, invokeInfo.insn.desc, 0, objectClass, invokeInfo.args, depth + 1, uncertain, null);
                    continue;
                }
                Disassembly.disassembly(invokeInfo.insn.owner, invokeInfo.insn.name, invokeInfo.insn.desc, 0, null, invokeInfo.args, depth + 1, true, null);
                continue;
            }
            if (!invokeInfo.calledOnThis) continue;
            Disassembly.disassembly(invokeInfo.insn.owner, invokeInfo.insn.name, invokeInfo.insn.desc, 0, objectClass, invokeInfo.args, depth + 1, uncertain, null);
        }
        fullTemplateMap.put(methodFullID, template);
        args.compound.merge(template, args.string);
    }

    private static boolean isHiddenTag(String tag) {
        return (Boolean)ModConfig.hideForgeTags.val != false && (tag.equals("ForgeCaps") || tag.equals("ForgeData") || tag.startsWith("forge:") || tag.startsWith("neoforge:") || tag.equals("NeoForgeData"));
    }

    public static class Template {
        public final List<SuggestionTemplate> suggestions = new ArrayList<SuggestionTemplate>();
        @Nullable
        public List<InvokeInfo> invokes = null;

        public void addSuggestion(@Nullable SuggestionTemplate suggestion) {
            if (suggestion == null) {
                return;
            }
            this.suggestions.removeIf(listElement -> listElement.tag.equals(suggestion.tag));
            this.suggestions.add(suggestion);
        }

        public void merge(Template templates, @Nullable String toReplace) {
            templates.suggestions.forEach(template -> this.addSuggestion(template.copy(null, true, toReplace)));
        }

        public void applyTemplate(NbtSuggestions nbtSuggestions) {
            this.suggestions.forEach(template -> nbtSuggestions.add(template.applyTemplate()));
        }

        public Template copy(@Nullable Map<Template, Template> templateMap, boolean replace, @Nullable String toReplace) {
            Template template = new Template();
            if (templateMap == null && this.invokes != null) {
                templateMap = new IdentityHashMap<Template, Template>();
            }
            if (templateMap != null) {
                templateMap.put(this, template);
            }
            for (SuggestionTemplate suggestionTemplate : this.suggestions) {
                template.addSuggestion(suggestionTemplate.copy(templateMap, replace, toReplace));
            }
            if (templateMap != null && this.invokes != null) {
                template.invokes = new ArrayList<InvokeInfo>();
                for (InvokeInfo invoke : this.invokes) {
                    Template newCompound = templateMap.get(invoke.args.compound);
                    if (newCompound == null) continue;
                    template.invokes.add(invoke.copy(newCompound));
                }
            }
            return template;
        }
    }

    public static class MethodArgs {
        public final Template compound;
        @Nullable
        public final String string;

        public MethodArgs(Template compound, @Nullable String string) {
            this.compound = compound;
            this.string = string;
        }

        @Nullable
        public static MethodArgs getArgs(List<? extends TrackedValue> values, boolean isStatic) {
            int i;
            Template compound = null;
            String string = null;
            int n = i = isStatic ? 0 : 1;
            while (i < values.size()) {
                TrackedValue trackedValue = values.get(i);
                if (trackedValue.type == TrackedValue.Type.COMPOUND || trackedValue.type == TrackedValue.Type.LIST_TAG) {
                    if (compound == null) {
                        compound = (Template)trackedValue.object;
                    }
                } else if (trackedValue.type == TrackedValue.Type.STRING && string == null) {
                    string = (String)trackedValue.object;
                }
                ++i;
            }
            return compound != null ? new MethodArgs(compound, string) : null;
        }
    }

    public static class ValueTracker
    extends Interpreter<TrackedValue> {
        @Nullable
        private final Template arg;
        private final boolean uncertain;
        private final boolean keepAllInvokes;
        private final BasicInterpreter basicInterpreter = new BasicInterpreter();
        private final Set<AbstractInsnNode> insnSet = new HashSet<AbstractInsnNode>();
        public final List<InvokeInfo> invokes = new ArrayList<InvokeInfo>();

        public ValueTracker(@Nullable Template arg, boolean uncertain, boolean keepAllInvokes) {
            super(589824);
            this.arg = arg;
            this.uncertain = uncertain;
            this.keepAllInvokes = keepAllInvokes;
            if (arg != null) {
                arg.invokes = this.invokes;
            }
        }

        public TrackedValue newValue(Type type) {
            return TrackedValue.unknown(this.basicInterpreter.newValue(type));
        }

        public TrackedValue newParameterValue(boolean isInstanceMethod, int local, Type type) {
            BasicValue basicValue = (BasicValue)this.basicInterpreter.newParameterValue(isInstanceMethod, local, type);
            if (isInstanceMethod && local == 0) {
                return TrackedValue.create(TrackedValue.Type.THIS, null, basicValue);
            }
            if (type.getClassName().equals(COMPOUND_TAG_ARG_SIGNATURE)) {
                if (this.arg != null) {
                    return TrackedValue.create(TrackedValue.Type.COMPOUND, this.arg, basicValue);
                }
            } else if (type.getClassName().equals(LIST_TAG_ARG_SIGNATURE)) {
                if (this.arg != null) {
                    return TrackedValue.create(TrackedValue.Type.LIST_TAG, this.arg, basicValue);
                }
            } else if (type.getClassName().equals(STRING_ARG_SIGNATURE)) {
                return TrackedValue.create(TrackedValue.Type.STRING, "*", basicValue);
            }
            return TrackedValue.unknown(basicValue);
        }

        public TrackedValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
            BasicValue basicValue = this.basicInterpreter.newOperation(insn);
            switch (insn.getOpcode()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return TrackedValue.create(TrackedValue.Type.INTEGER, insn.getOpcode() - 3, basicValue);
                }
                case 16: 
                case 17: {
                    return TrackedValue.create(TrackedValue.Type.INTEGER, ((IntInsnNode)insn).operand, basicValue);
                }
                case 18: {
                    Object ldcVal = ((LdcInsnNode)insn).cst;
                    if (ldcVal instanceof Integer) {
                        return TrackedValue.create(TrackedValue.Type.INTEGER, ldcVal, basicValue);
                    }
                    if (!(ldcVal instanceof String)) break;
                    return TrackedValue.create(TrackedValue.Type.STRING, ldcVal, basicValue);
                }
            }
            return TrackedValue.unknown(basicValue);
        }

        public TrackedValue copyOperation(AbstractInsnNode insn, TrackedValue value) {
            return value;
        }

        public TrackedValue unaryOperation(AbstractInsnNode insn, TrackedValue value) throws AnalyzerException {
            BasicValue basicValue = this.basicInterpreter.unaryOperation(insn, value.basicValue);
            if (insn.getOpcode() == 192) {
                return TrackedValue.copy(value, basicValue);
            }
            return TrackedValue.unknown(basicValue);
        }

        public TrackedValue binaryOperation(AbstractInsnNode insn, TrackedValue value1, TrackedValue value2) throws AnalyzerException {
            BasicValue typeValue = this.basicInterpreter.binaryOperation(insn, value1.basicValue, value2.basicValue);
            return TrackedValue.unknown(typeValue);
        }

        public TrackedValue ternaryOperation(AbstractInsnNode insn, TrackedValue value1, TrackedValue value2, TrackedValue value3) {
            return null;
        }

        public TrackedValue naryOperation(AbstractInsnNode insn, List<? extends TrackedValue> values) throws AnalyzerException {
            BasicValue basicValue = this.basicInterpreter.naryOperation(insn, null);
            if (this.insnSet.add(insn) && (insn.getOpcode() == 182 || insn.getOpcode() == 184 || insn.getOpcode() == 183)) {
                MethodInsnNode methodInsn = (MethodInsnNode)insn;
                if (insn.getOpcode() == 182 && !this.keepAllInvokes) {
                    if (methodInsn.owner.equals(COMPOUND_TAG_SIGNATURE)) {
                        return this.onCompoundTagInvoke(methodInsn, values, basicValue);
                    }
                    if (methodInsn.owner.equals(LIST_TAG_SIGNATURE)) {
                        return this.onListTagInvoke(methodInsn, values, basicValue);
                    }
                }
                InvokeInfo.add(this.invokes, methodInsn, values, this.keepAllInvokes);
            }
            return TrackedValue.unknown(basicValue);
        }

        public void returnOperation(AbstractInsnNode insn, TrackedValue value, TrackedValue expected) {
        }

        public TrackedValue merge(TrackedValue value1, TrackedValue value2) {
            if (value1.equals(value2)) {
                return value1;
            }
            BasicValue basicValue = this.basicInterpreter.merge(value1.basicValue, value2.basicValue);
            if (basicValue.equals((Object)value1.basicValue) && value1.basicValue.equals((Object)value2.basicValue)) {
                return value1;
            }
            if (basicValue.equals((Object)value2.basicValue) && value2.basicValue.equals((Object)value1.basicValue)) {
                return value2;
            }
            return TrackedValue.unknown(basicValue);
        }

        private TrackedValue onCompoundTagInvoke(MethodInsnNode methodInsn, List<? extends TrackedValue> values, BasicValue basicValue) {
            if (values.size() < 2 || values.get((int)0).type != TrackedValue.Type.COMPOUND || values.get((int)1).type != TrackedValue.Type.STRING) {
                return TrackedValue.unknown(basicValue);
            }
            NbtSuggestion.Type type = NbtSuggestion.Type.fromMethodName(methodInsn.name);
            NbtSuggestion.Type listType = NbtSuggestion.Type.UNKNOWN;
            if (type == NbtSuggestion.Type.LIST && values.size() == 3) {
                if (values.get((int)2).type == TrackedValue.Type.INTEGER) {
                    listType = NbtSuggestion.Type.fromID(((Integer)values.get((int)2).object).byteValue());
                }
            } else if (values.size() != 2) {
                return TrackedValue.unknown(basicValue);
            }
            Template suggestions = (Template)values.get((int)0).object;
            String tagName = (String)values.get((int)1).object;
            if (Disassembly.isHiddenTag(tagName)) {
                return TrackedValue.unknown(basicValue);
            }
            SuggestionTemplate newSuggestion = this.uncertain ? new SuggestionTemplate(tagName, type, NbtSuggestion.Source.UNCERTAIN) : new SuggestionTemplate(tagName, type);
            suggestions.addSuggestion(newSuggestion);
            if (type == NbtSuggestion.Type.COMPOUND) {
                return TrackedValue.create(TrackedValue.Type.COMPOUND, newSuggestion.addSubcompound(), basicValue);
            }
            if (type == NbtSuggestion.Type.LIST) {
                newSuggestion.listType = listType;
                if (listType == NbtSuggestion.Type.COMPOUND) {
                    return TrackedValue.create(TrackedValue.Type.LIST_TAG, newSuggestion.addSubcompound(), basicValue);
                }
            }
            return TrackedValue.unknown(basicValue);
        }

        private TrackedValue onListTagInvoke(MethodInsnNode methodInsn, List<? extends TrackedValue> values, BasicValue basicValue) {
            if (values.size() != 2 || values.get((int)0).type != TrackedValue.Type.LIST_TAG || !methodInsn.desc.equals("(I)L" + CompoundTag.class.getName().replace('.', '/') + ";")) {
                return TrackedValue.unknown(basicValue);
            }
            return TrackedValue.create(TrackedValue.Type.COMPOUND, values.get((int)0).object, basicValue);
        }
    }

    public static class InvokeInfo {
        public final MethodInsnNode insn;
        public final MethodArgs args;
        public final boolean calledOnThis;

        public InvokeInfo(MethodInsnNode insn, MethodArgs args, boolean calledOnThis) {
            this.insn = insn;
            this.args = args;
            this.calledOnThis = calledOnThis;
        }

        public InvokeInfo copy(Template newCompound) {
            return new InvokeInfo(this.insn, new MethodArgs(newCompound, this.args.string), this.calledOnThis);
        }

        public static void add(List<InvokeInfo> invokes, MethodInsnNode insn, List<? extends TrackedValue> values, boolean keepAllInvokes) {
            boolean calledOnThis;
            MethodArgs args = MethodArgs.getArgs(values, insn.getOpcode() == 184);
            boolean bl = calledOnThis = insn.getOpcode() != 184 && InvokeInfo.isCalledOnThis(values);
            if (args != null || keepAllInvokes) {
                invokes.add(new InvokeInfo(insn, args, calledOnThis));
            }
        }

        private static boolean isCalledOnThis(List<? extends TrackedValue> values) {
            return !values.isEmpty() && values.get((int)0).type == TrackedValue.Type.THIS;
        }
    }

    public static class SuggestionTemplate {
        public String tag;
        public NbtSuggestion.Type type;
        public NbtSuggestion.Type listType = NbtSuggestion.Type.UNKNOWN;
        public Template subcompound = null;
        public NbtSuggestion.Source source = NbtSuggestion.Source.DEFAULT;

        public SuggestionTemplate(String tag, NbtSuggestion.Type type) {
            this.tag = tag;
            this.type = type;
        }

        public SuggestionTemplate(String tag, NbtSuggestion.Type type, NbtSuggestion.Source source) {
            this(tag, type);
            this.source = source;
        }

        public Template addSubcompound() {
            this.subcompound = new Template();
            return this.subcompound;
        }

        public NbtSuggestion applyTemplate() {
            NbtSuggestion nbtSuggestion = new NbtSuggestion(this.tag, this.type, this.source, this.listType);
            if (this.subcompound != null && !this.subcompound.suggestions.isEmpty()) {
                this.subcompound.applyTemplate(nbtSuggestion.getSubcompound());
            }
            return nbtSuggestion;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public SuggestionTemplate copy(@Nullable Map<Template, Template> templateMap, boolean replace, @Nullable String toReplace) {
            String newTag;
            if (replace && this.tag.equals("*")) {
                if (toReplace == null || Disassembly.isHiddenTag(toReplace)) return null;
                newTag = toReplace;
            } else {
                newTag = this.tag;
            }
            SuggestionTemplate newTemplate = new SuggestionTemplate(newTag, this.type, this.source);
            newTemplate.listType = this.listType;
            if (this.subcompound == null) return newTemplate;
            newTemplate.subcompound = this.subcompound.copy(templateMap, replace, toReplace);
            return newTemplate;
        }
    }

    public static class TrackedValue
    implements Value {
        public final Type type;
        public final Object object;
        public final BasicValue basicValue;

        private TrackedValue(Type type, Object object, BasicValue basicValue) {
            this.type = type;
            this.object = object;
            this.basicValue = basicValue;
        }

        @Nullable
        public static TrackedValue create(Type type, Object object, @Nullable BasicValue basicValue) {
            return basicValue != null ? new TrackedValue(type, object, basicValue) : null;
        }

        @Nullable
        public static TrackedValue copy(TrackedValue trackedValue, @Nullable BasicValue basicValue) {
            return basicValue != null ? new TrackedValue(trackedValue.type, trackedValue.object, basicValue) : null;
        }

        @Nullable
        public static TrackedValue unknown(@Nullable BasicValue basicValue) {
            return basicValue != null ? new TrackedValue(Type.UNKNOWN, null, basicValue) : null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TrackedValue)) {
                return false;
            }
            TrackedValue valueToCompare = (TrackedValue)obj;
            if (this.type != valueToCompare.type) {
                return false;
            }
            if (this.object == null != (valueToCompare.object == null)) {
                return false;
            }
            if (this.object != null && !this.object.equals(valueToCompare.object)) {
                return false;
            }
            return this.basicValue.equals((Object)valueToCompare.basicValue);
        }

        public int getSize() {
            return this.basicValue.getSize();
        }

        public static enum Type {
            STRING,
            INTEGER,
            COMPOUND,
            LIST_TAG,
            THIS,
            UNKNOWN;

        }
    }
}

